/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.io.BaseEncoding;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlots;
import com.microsoft.azure.management.appservice.NameValuePair;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.SkuDescription;
import com.microsoft.azure.management.appservice.implementation.AppServiceBaseImpl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.FunctionDeploymentSlotsImpl;
import com.microsoft.azure.management.appservice.implementation.KuduClient;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.rest.LogLevel;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.credentials.TokenCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Request;
import org.joda.time.DateTime;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Completable;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class FunctionAppImpl
extends AppServiceBaseImpl<FunctionApp, FunctionAppImpl, FunctionApp.DefinitionStages.WithCreate, FunctionApp.Update>
implements FunctionApp,
FunctionApp.Definition,
FunctionApp.DefinitionStages.NewAppServicePlanWithGroup,
FunctionApp.Update {
    private Creatable<StorageAccount> storageAccountCreatable;
    private StorageAccount storageAccountToSet;
    private StorageAccount currentStorageAccount;
    private final FunctionAppKeyService functionAppKeyService;
    private final FunctionService functionService;
    private final KuduClient kuduClient;
    private FunctionDeploymentSlots deploymentSlots;

    FunctionAppImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, AppServiceManager manager) {
        super(name, innerObject, configObject, manager);
        this.functionAppKeyService = (FunctionAppKeyService)manager.restClient().retrofit().create(FunctionAppKeyService.class);
        String defaultHostName = this.defaultHostName().startsWith("http") ? this.defaultHostName() : "http://" + this.defaultHostName();
        this.functionService = (FunctionService)manager.restClient().newBuilder().withBaseUrl(defaultHostName).withCredentials((ServiceClientCredentials)new FunctionCredentials(this)).withLogLevel(LogLevel.BODY_AND_HEADERS).build().retrofit().create(FunctionService.class);
        this.kuduClient = new KuduClient(this);
    }

    @Override
    public FunctionDeploymentSlots deploymentSlots() {
        if (this.deploymentSlots == null) {
            this.deploymentSlots = new FunctionDeploymentSlotsImpl(this);
        }
        return this.deploymentSlots;
    }

    @Override
    public FunctionAppImpl withNewConsumptionPlan() {
        return this.withNewAppServicePlan(OperatingSystem.WINDOWS, new PricingTier("Dynamic", "Y1"));
    }

    @Override
    public FunctionAppImpl withRuntimeVersion(String version) {
        return (FunctionAppImpl)this.withAppSetting("FUNCTIONS_EXTENSION_VERSION", version.startsWith("~") ? version : "~" + version);
    }

    @Override
    public FunctionAppImpl withLatestRuntimeVersion() {
        return this.withRuntimeVersion("latest");
    }

    @Override
    Observable<Indexable> submitAppSettings() {
        if (this.storageAccountCreatable != null && this.taskResult(this.storageAccountCreatable.key()) != null) {
            this.storageAccountToSet = (StorageAccount)this.taskResult(this.storageAccountCreatable.key());
        }
        if (this.storageAccountToSet == null) {
            return super.submitAppSettings();
        }
        return this.storageAccountToSet.getKeysAsync().flatMapIterable((Func1)new Func1<List<StorageAccountKey>, Iterable<StorageAccountKey>>(){

            public Iterable<StorageAccountKey> call(List<StorageAccountKey> storageAccountKeys) {
                return storageAccountKeys;
            }
        }).first().flatMap((Func1)new Func1<StorageAccountKey, Observable<Indexable>>(){

            public Observable<Indexable> call(StorageAccountKey storageAccountKey) {
                String connectionString = String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s", FunctionAppImpl.this.storageAccountToSet.name(), storageAccountKey.value());
                FunctionAppImpl.this.withAppSetting("AzureWebJobsStorage", connectionString);
                FunctionAppImpl.this.withAppSetting("AzureWebJobsDashboard", connectionString);
                FunctionAppImpl.this.withAppSetting("WEBSITE_CONTENTAZUREFILECONNECTIONSTRING", connectionString);
                FunctionAppImpl.this.withAppSetting("WEBSITE_CONTENTSHARE", SdkContext.randomResourceName((String)FunctionAppImpl.this.name(), (int)32));
                return FunctionAppImpl.super.submitAppSettings();
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                FunctionAppImpl.this.currentStorageAccount = FunctionAppImpl.this.storageAccountToSet;
                FunctionAppImpl.this.storageAccountToSet = null;
                FunctionAppImpl.this.storageAccountCreatable = null;
            }
        });
    }

    @Override
    FunctionAppImpl withNewAppServicePlan(OperatingSystem operatingSystem, PricingTier pricingTier) {
        return ((FunctionAppImpl)super.withNewAppServicePlan(operatingSystem, pricingTier)).autoSetAlwaysOn(pricingTier);
    }

    @Override
    public FunctionAppImpl withExistingAppServicePlan(AppServicePlan appServicePlan) {
        super.withExistingAppServicePlan(appServicePlan);
        return this.autoSetAlwaysOn(appServicePlan.pricingTier());
    }

    private FunctionAppImpl autoSetAlwaysOn(PricingTier pricingTier) {
        SkuDescription description = pricingTier.toSkuDescription();
        if (description.tier().equalsIgnoreCase("Basic") || description.tier().equalsIgnoreCase("Standard") || description.tier().equalsIgnoreCase("Premium")) {
            return (FunctionAppImpl)this.withWebAppAlwaysOn(true);
        }
        return (FunctionAppImpl)this.withWebAppAlwaysOn(false);
    }

    @Override
    public FunctionAppImpl withNewStorageAccount(String name, SkuName sku) {
        StorageAccount.DefinitionStages.WithGroup storageDefine = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)((AppServiceManager)this.manager()).storageManager().storageAccounts().define(name)).withRegion(this.regionName());
        this.storageAccountCreatable = this.creatableGroup != null && this.isInCreateMode() ? ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withNewResourceGroup(this.creatableGroup)).withGeneralPurposeAccountKind().withSku(sku) : ((StorageAccount.DefinitionStages.WithCreate)storageDefine.withExistingResourceGroup(this.resourceGroupName())).withGeneralPurposeAccountKind().withSku(sku);
        this.addDependency(this.storageAccountCreatable);
        return this;
    }

    @Override
    public FunctionAppImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.storageAccountToSet = storageAccount;
        return this;
    }

    @Override
    public FunctionAppImpl withDailyUsageQuota(int quota) {
        ((SiteInner)((Object)this.inner())).withDailyMemoryTimeQuota(quota);
        return this;
    }

    @Override
    public FunctionAppImpl withoutDailyUsageQuota() {
        return this.withDailyUsageQuota(0);
    }

    @Override
    public StorageAccount storageAccount() {
        return this.currentStorageAccount;
    }

    @Override
    public String getMasterKey() {
        return (String)this.getMasterKeyAsync().toBlocking().single();
    }

    @Override
    public Observable<String> getMasterKeyAsync() {
        return this.functionAppKeyService.getMasterKey(this.resourceGroupName(), this.name(), ((AppServiceManager)this.manager()).subscriptionId(), "2016-08-01", ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).userAgent()).map((Func1)new Func1<Map<String, String>, String>(){

            public String call(Map<String, String> stringStringMap) {
                return stringStringMap.get("masterKey");
            }
        });
    }

    @Override
    public Map<String, String> listFunctionKeys(String functionName) {
        return (Map)this.listFunctionKeysAsync(functionName).toBlocking().single();
    }

    @Override
    public Observable<Map<String, String>> listFunctionKeysAsync(String functionName) {
        return this.functionService.listFunctionKeys(functionName).map((Func1)new Func1<FunctionKeyListResult, Map<String, String>>(){

            public Map<String, String> call(FunctionKeyListResult result) {
                HashMap<String, String> keys = new HashMap<String, String>();
                if (result.keys != null) {
                    for (NameValuePair pair : result.keys) {
                        keys.put(pair.name(), pair.value());
                    }
                }
                return keys;
            }
        });
    }

    @Override
    public NameValuePair addFunctionKey(String functionName, String keyName, String keyValue) {
        return (NameValuePair)this.addFunctionKeyAsync(functionName, keyName, keyValue).toBlocking().single();
    }

    @Override
    public Observable<NameValuePair> addFunctionKeyAsync(String functionName, String keyName, String keyValue) {
        if (keyValue != null) {
            return this.functionService.addFunctionKey(functionName, keyName, new NameValuePair().withName(keyName).withValue(keyValue));
        }
        return this.functionService.generateFunctionKey(functionName, keyName);
    }

    @Override
    public void removeFunctionKey(String functionName, String keyName) {
        this.removeFunctionKeyAsync(functionName, keyName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable removeFunctionKeyAsync(String functionName, String keyName) {
        return this.functionService.deleteFunctionKey(functionName, keyName).toCompletable();
    }

    @Override
    public void syncTriggers() {
        this.syncTriggersAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable syncTriggersAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().syncFunctionTriggersAsync(this.resourceGroupName(), this.name()).toCompletable().onErrorResumeNext((Func1)new Func1<Throwable, Completable>(){

            public Completable call(Throwable throwable) {
                if (throwable instanceof CloudException && ((CloudException)throwable).response().code() == 200) {
                    return Completable.complete();
                }
                return Completable.error((Throwable)throwable);
            }
        });
    }

    @Override
    public InputStream streamApplicationLogs() {
        PipedInputStreamWithCallback in = new PipedInputStreamWithCallback();
        final PipedOutputStream out = new PipedOutputStream();
        try {
            in.connect(out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final Subscription subscription = this.streamApplicationLogsAsync().subscribeOn(Schedulers.newThread()).subscribe((Action1)new Action1<String>(){

            public void call(String s) {
                try {
                    out.write(s.getBytes());
                    out.write(10);
                    out.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        in.addCallback(new Action0(){

            public void call() {
                subscription.unsubscribe();
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return in;
    }

    @Override
    public Observable<String> streamApplicationLogsAsync() {
        return this.functionService.ping().flatMap((Func1)new Func1<Void, Observable<String>>(){

            public Observable<String> call(Void aVoid) {
                return FunctionAppImpl.this.kuduClient.streamApplicationLogsAsync();
            }
        });
    }

    public Observable<Indexable> createAsync() {
        if (((SiteInner)((Object)this.inner())).serverFarmId() == null) {
            this.withNewConsumptionPlan();
        }
        if (this.currentStorageAccount == null && this.storageAccountToSet == null && this.storageAccountCreatable == null) {
            this.withNewStorageAccount(SdkContext.randomResourceName((String)this.name(), (int)20), SkuName.STANDARD_GRS);
        }
        return super.createAsync();
    }

    private static class PipedInputStreamWithCallback
    extends PipedInputStream {
        private Action0 callback;

        private PipedInputStreamWithCallback() {
        }

        private void addCallback(Action0 action) {
            this.callback = action;
        }

        @Override
        public void close() throws IOException {
            this.callback.call();
            super.close();
        }
    }

    private static final class FunctionCredentials
    extends TokenCredentials {
        private String token;
        private long expire;
        private final FunctionAppImpl functionApp;

        private FunctionCredentials(FunctionAppImpl functionApp) {
            super("Bearer", null);
            this.functionApp = functionApp;
        }

        public String getToken(Request request) {
            if (this.token == null || this.expire < DateTime.now().getMillis()) {
                this.token = ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.functionApp.manager()).inner())).webApps().getFunctionsAdminToken(this.functionApp.resourceGroupName(), this.functionApp.name());
                String jwt = new String(BaseEncoding.base64Url().decode((CharSequence)this.token.split("\\.")[1]));
                Pattern pattern = Pattern.compile("\"exp\": *([0-9]+),");
                Matcher matcher = pattern.matcher(jwt);
                matcher.find();
                this.expire = Long.parseLong(matcher.group(1));
            }
            return this.token;
        }
    }

    private static class FunctionKeyListResult {
        @JsonProperty(value="keys")
        private List<NameValuePair> keys;

        private FunctionKeyListResult() {
        }
    }

    private static interface FunctionService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps listFunctionKeys"})
        @GET(value="admin/functions/{name}/keys")
        public Observable<FunctionKeyListResult> listFunctionKeys(@Path(value="name") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps addFunctionKey"})
        @PUT(value="admin/functions/{name}/keys/{keyName}")
        public Observable<NameValuePair> addFunctionKey(@Path(value="name") String var1, @Path(value="keyName") String var2, @Body NameValuePair var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps generateFunctionKey"})
        @POST(value="admin/functions/{name}/keys/{keyName}")
        public Observable<NameValuePair> generateFunctionKey(@Path(value="name") String var1, @Path(value="keyName") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps deleteFunctionKey"})
        @DELETE(value="admin/functions/{name}/keys/{keyName}")
        public Observable<Void> deleteFunctionKey(@Path(value="name") String var1, @Path(value="keyName") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps ping"})
        @POST(value="admin/host/ping")
        public Observable<Void> ping();
    }

    private static interface FunctionAppKeyService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.WebApps getMasterKey"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/functions/admin/masterkey")
        public Observable<Map<String, String>> getMasterKey(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="User-Agent") String var5);
    }
}

