/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServiceDomain;
import com.microsoft.azure.management.appservice.AzureResourceType;
import com.microsoft.azure.management.appservice.CustomHostNameDnsRecordType;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.HostNameBinding;
import com.microsoft.azure.management.appservice.HostNameType;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class HostNameBindingImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<HostNameBindingInner>
implements Creatable<HostNameBinding>,
HostNameBinding,
HostNameBinding.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
HostNameBinding.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final FluentImplT parent;
    private String domainName;
    private String name;

    HostNameBindingImpl(HostNameBindingInner innerObject, FluentImplT parent) {
        super((Object)innerObject);
        this.parent = parent;
        this.name = innerObject.name();
        if (this.name != null && this.name.contains("/")) {
            this.name = this.name.replace(parent.name() + "/", "");
        }
    }

    public String id() {
        return ((HostNameBindingInner)this.inner()).id();
    }

    public String type() {
        return ((HostNameBindingInner)this.inner()).type();
    }

    public String regionName() {
        return this.parent().regionName();
    }

    public Region region() {
        return this.parent().region();
    }

    public Map<String, String> tags() {
        return this.parent().tags();
    }

    @Override
    public String webAppName() {
        return ((HostNameBindingInner)this.inner()).siteName();
    }

    @Override
    public String domainId() {
        return ((HostNameBindingInner)this.inner()).domainId();
    }

    @Override
    public String azureResourceName() {
        return ((HostNameBindingInner)this.inner()).azureResourceName();
    }

    @Override
    public AzureResourceType azureResourceType() {
        return ((HostNameBindingInner)this.inner()).azureResourceType();
    }

    @Override
    public CustomHostNameDnsRecordType dnsRecordType() {
        return ((HostNameBindingInner)this.inner()).customHostNameDnsRecordType();
    }

    @Override
    public HostNameType hostNameType() {
        return ((HostNameBindingInner)this.inner()).hostNameType();
    }

    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent).withHostNameBinding(this);
        return this.parent;
    }

    public HostNameBindingImpl<FluentT, FluentImplT> withDnsRecordType(CustomHostNameDnsRecordType hostNameDnsRecordType) {
        Pattern pattern = Pattern.compile("([.\\w-]+)\\.([\\w-]+\\.\\w+)");
        Matcher matcher = pattern.matcher(this.name);
        if (hostNameDnsRecordType == CustomHostNameDnsRecordType.CNAME && !matcher.matches()) {
            throw new IllegalArgumentException("root hostname cannot be assigned with a CName record");
        }
        ((HostNameBindingInner)this.inner()).withCustomHostNameDnsRecordType(hostNameDnsRecordType);
        return this;
    }

    public HostNameBindingImpl<FluentT, FluentImplT> refresh() {
        return this;
    }

    public Observable<HostNameBinding> refreshAsync() {
        final HostNameBindingImpl self = this;
        Observable<HostNameBindingInner> observable = null;
        observable = this.parent instanceof DeploymentSlot ? ((WebSiteManagementClientImpl)((Object)((AppServiceManager)((Object)this.parent().manager())).inner())).webApps().getHostNameBindingSlotAsync(this.parent().resourceGroupName(), ((WebApp)((DeploymentSlot)this.parent).parent()).name(), this.parent().name(), this.name()) : ((WebSiteManagementClientImpl)((Object)((AppServiceManager)((Object)this.parent().manager())).inner())).webApps().getHostNameBindingAsync(this.parent().resourceGroupName(), this.parent().name(), this.name());
        return observable.map((Func1)new Func1<HostNameBindingInner, HostNameBinding>(){

            public HostNameBinding call(HostNameBindingInner hostNameBindingInner) {
                self.setInner(hostNameBindingInner);
                return self;
            }
        });
    }

    public HostNameBinding create() {
        this.createAsync().toBlocking().subscribe();
        return this;
    }

    public ServiceFuture<HostNameBinding> createAsync(ServiceCallback<HostNameBinding> callback) {
        Observable<Indexable> indexableObservable = this.createAsync();
        return ServiceFuture.fromBody((Observable)Utils.rootResource(indexableObservable), callback);
    }

    public Observable<Indexable> createAsync() {
        final HostNameBindingImpl self = this;
        Func1<HostNameBindingInner, HostNameBinding> mapper = new Func1<HostNameBindingInner, HostNameBinding>(){

            public HostNameBinding call(HostNameBindingInner hostNameBindingInner) {
                HostNameBindingImpl.this.setInner(hostNameBindingInner);
                return self;
            }
        };
        Observable hostNameBindingObservable = this.parent instanceof DeploymentSlot ? ((WebSiteManagementClientImpl)((Object)((AppServiceManager)((Object)this.parent().manager())).inner())).webApps().createOrUpdateHostNameBindingSlotAsync(this.parent().resourceGroupName(), ((WebApp)((DeploymentSlot)this.parent).parent()).name(), this.name, this.parent().name(), (HostNameBindingInner)this.inner()).map((Func1)mapper) : ((WebSiteManagementClientImpl)((Object)((AppServiceManager)((Object)this.parent().manager())).inner())).webApps().createOrUpdateHostNameBindingAsync(this.parent().resourceGroupName(), this.parent().name(), this.name, (HostNameBindingInner)this.inner()).map((Func1)mapper);
        return hostNameBindingObservable.map((Func1)new Func1<HostNameBinding, Indexable>(){

            public Indexable call(HostNameBinding hostNameBinding) {
                return hostNameBinding;
            }
        });
    }

    private String normalizeHostNameBindingName(String hostname, String domainName) {
        if (!hostname.endsWith(domainName)) {
            hostname = hostname + "." + domainName;
        }
        if (hostname.startsWith("@")) {
            hostname = hostname.replace("@.", "");
        }
        return hostname;
    }

    public HostNameBindingImpl<FluentT, FluentImplT> withAzureManagedDomain(AppServiceDomain domain) {
        ((HostNameBindingInner)this.inner()).withDomainId(domain.id());
        ((HostNameBindingInner)this.inner()).withHostNameType(HostNameType.MANAGED);
        this.domainName = domain.name();
        return this;
    }

    public HostNameBindingImpl<FluentT, FluentImplT> withThirdPartyDomain(String domain) {
        ((HostNameBindingInner)this.inner()).withHostNameType(HostNameType.VERIFIED);
        this.domainName = domain;
        return this;
    }

    public String toString() {
        String suffix = this.azureResourceType() == AzureResourceType.TRAFFIC_MANAGER ? ".trafficmanager.net" : ".azurewebsites.net";
        return this.name + ": " + (Object)((Object)this.dnsRecordType()) + " " + this.azureResourceName() + suffix;
    }

    public String name() {
        return this.name;
    }

    public WebAppBase parent() {
        return this.parent;
    }

    public HostNameBindingImpl<FluentT, FluentImplT> withSubDomain(String subDomain) {
        this.name = this.normalizeHostNameBindingName(subDomain, this.domainName);
        return this;
    }
}

