/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.implementation.CsmOperationDescriptionInner;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ProvidersInner {
    private ProvidersService service;
    private WebSiteManagementClientImpl client;

    public ProvidersInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (ProvidersService)retrofit.create(ProvidersService.class);
        this.client = client;
    }

    public Object getAvailableStacks() {
        return ((ServiceResponse)this.getAvailableStacksWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<Object> getAvailableStacksAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAvailableStacksWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Object> getAvailableStacksAsync() {
        return this.getAvailableStacksWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> getAvailableStacksWithServiceResponseAsync() {
        String apiVersion = "2016-03-01";
        return this.service.getAvailableStacks("2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getAvailableStacksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getAvailableStacksDelegate(Response<ResponseBody> response) throws CloudException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<CsmOperationDescriptionInner> listOperations() {
        ServiceResponse response = (ServiceResponse)this.listOperationsSinglePageAsync().toBlocking().single();
        return new PagedList<CsmOperationDescriptionInner>((Page)response.body()){

            public Page<CsmOperationDescriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CsmOperationDescriptionInner>> listOperationsAsync(ListOperationCallback<CsmOperationDescriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOperationsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CsmOperationDescriptionInner>> listOperationsAsync() {
        return this.listOperationsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Page<CsmOperationDescriptionInner>>(){

            public Page<CsmOperationDescriptionInner> call(ServiceResponse<Page<CsmOperationDescriptionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsWithServiceResponseAsync() {
        return this.listOperationsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(ServiceResponse<Page<CsmOperationDescriptionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listOperationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsSinglePageAsync() {
        String apiVersion = "2016-03-01";
        return this.service.listOperations("2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listOperationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CsmOperationDescriptionInner>> listOperationsDelegate(Response<ResponseBody> response) throws CloudException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CsmOperationDescriptionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public Object getAvailableStacksOnPrem() {
        return ((ServiceResponse)this.getAvailableStacksOnPremWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<Object> getAvailableStacksOnPremAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAvailableStacksOnPremWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Object> getAvailableStacksOnPremAsync() {
        return this.getAvailableStacksOnPremWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> getAvailableStacksOnPremWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getAvailableStacksOnPrem(this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getAvailableStacksOnPremDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getAvailableStacksOnPremDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<CsmOperationDescriptionInner> listOperationsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CsmOperationDescriptionInner>((Page)response.body()){

            public Page<CsmOperationDescriptionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<CsmOperationDescriptionInner>> listOperationsNextAsync(String nextPageLink, ServiceFuture<List<CsmOperationDescriptionInner>> serviceFuture, ListOperationCallback<CsmOperationDescriptionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOperationsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listOperationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CsmOperationDescriptionInner>> listOperationsNextAsync(String nextPageLink) {
        return this.listOperationsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Page<CsmOperationDescriptionInner>>(){

            public Page<CsmOperationDescriptionInner> call(ServiceResponse<Page<CsmOperationDescriptionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listOperationsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CsmOperationDescriptionInner>>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(ServiceResponse<Page<CsmOperationDescriptionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listOperationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> listOperationsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listOperationsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>>>(){

            public Observable<ServiceResponse<Page<CsmOperationDescriptionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listOperationsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CsmOperationDescriptionInner>> listOperationsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CsmOperationDescriptionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProvidersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacks"})
        @GET(value="providers/Microsoft.Web/availableStacks")
        public Observable<Response<ResponseBody>> getAvailableStacks(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listOperations"})
        @GET(value="providers/Microsoft.Web/operations")
        public Observable<Response<ResponseBody>> listOperations(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacksOnPrem"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        public Observable<Response<ResponseBody>> getAvailableStacksOnPrem(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers listOperationsNext"})
        @GET
        public Observable<Response<ResponseBody>> listOperationsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

