/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppServiceCertificate;
import com.microsoft.azure.management.appservice.AppServiceDomain;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.AzureResourceType;
import com.microsoft.azure.management.appservice.CloningInfo;
import com.microsoft.azure.management.appservice.ConnStringValueTypePair;
import com.microsoft.azure.management.appservice.ConnectionString;
import com.microsoft.azure.management.appservice.ConnectionStringType;
import com.microsoft.azure.management.appservice.CustomHostNameDnsRecordType;
import com.microsoft.azure.management.appservice.FileSystemHttpLogsConfig;
import com.microsoft.azure.management.appservice.HostNameBinding;
import com.microsoft.azure.management.appservice.HostNameSslState;
import com.microsoft.azure.management.appservice.HostNameType;
import com.microsoft.azure.management.appservice.HttpLogsConfig;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.ManagedPipelineMode;
import com.microsoft.azure.management.appservice.ManagedServiceIdentity;
import com.microsoft.azure.management.appservice.NetFrameworkVersion;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.PhpVersion;
import com.microsoft.azure.management.appservice.PlatformArchitecture;
import com.microsoft.azure.management.appservice.PythonVersion;
import com.microsoft.azure.management.appservice.RemoteVisualStudioVersion;
import com.microsoft.azure.management.appservice.ScmType;
import com.microsoft.azure.management.appservice.SiteAvailabilityState;
import com.microsoft.azure.management.appservice.SiteConfig;
import com.microsoft.azure.management.appservice.SslState;
import com.microsoft.azure.management.appservice.UsageState;
import com.microsoft.azure.management.appservice.WebAppAuthentication;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.AppSettingImpl;
import com.microsoft.azure.management.appservice.implementation.ConnectionStringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.ConnectionStringImpl;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingImpl;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingInner;
import com.microsoft.azure.management.appservice.implementation.HostNameSslBindingImpl;
import com.microsoft.azure.management.appservice.implementation.MSDeployInner;
import com.microsoft.azure.management.appservice.implementation.MSDeployStatusInner;
import com.microsoft.azure.management.appservice.implementation.SiteAuthSettingsInner;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.SiteSourceControlInner;
import com.microsoft.azure.management.appservice.implementation.SlotConfigNamesResourceInner;
import com.microsoft.azure.management.appservice.implementation.SourceControlInner;
import com.microsoft.azure.management.appservice.implementation.StringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.WebAppAuthenticationImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppSourceControlImpl;
import com.microsoft.azure.management.appservice.implementation.WebDeploymentImpl;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.FuncN;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
abstract class WebAppBaseImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends GroupableResourceImpl<FluentT, SiteInner, FluentImplT, AppServiceManager>
implements WebAppBase,
WebAppBase.Definition<FluentT>,
WebAppBase.Update<FluentT>,
WebAppBase.UpdateStages.WithWebContainer<FluentT> {
    SiteConfigResourceInner siteConfig;
    private Set<String> hostNamesSet;
    private Set<String> enabledHostNamesSet;
    private Set<String> trafficManagerHostNamesSet;
    private Set<String> outboundIPAddressesSet;
    private Map<String, HostNameSslState> hostNameSslStateMap;
    private TreeMap<String, HostNameBindingImpl<FluentT, FluentImplT>> hostNameBindingsToCreate;
    private List<String> hostNameBindingsToDelete;
    private TreeMap<String, HostNameSslBindingImpl<FluentT, FluentImplT>> sslBindingsToCreate;
    private Map<String, String> appSettingsToAdd;
    private List<String> appSettingsToRemove;
    private Map<String, Boolean> appSettingStickiness;
    private Map<String, ConnStringValueTypePair> connectionStringsToAdd;
    private List<String> connectionStringsToRemove;
    private Map<String, Boolean> connectionStringStickiness;
    private WebAppSourceControlImpl<FluentT, FluentImplT> sourceControl;
    private boolean sourceControlToDelete;
    private MSDeployInner msDeploy;
    private WebAppAuthenticationImpl<FluentT, FluentImplT> authentication;
    private boolean authenticationToUpdate;
    private SiteLogsConfigInner siteLogsConfig;
    private FunctionalTaskItem msiHandler;
    private boolean isInCreateMode;

    WebAppBaseImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, AppServiceManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        if (innerObject != null && innerObject.kind() != null) {
            innerObject.withKind(innerObject.kind().replace(";", ","));
        }
        this.siteConfig = configObject;
        this.normalizeProperties();
        this.isInCreateMode = this.inner() == null || ((SiteInner)((Object)this.inner())).id() == null;
    }

    public boolean isInCreateMode() {
        return this.isInCreateMode;
    }

    public void setInner(SiteInner innerObject) {
        if (innerObject.kind() != null) {
            innerObject.withKind(innerObject.kind().replace(";", ","));
        }
        super.setInner((Object)innerObject);
    }

    private FluentT normalizeProperties() {
        this.hostNameBindingsToCreate = new TreeMap();
        this.hostNameBindingsToDelete = new ArrayList<String>();
        this.appSettingsToAdd = new HashMap<String, String>();
        this.appSettingsToRemove = new ArrayList<String>();
        this.appSettingStickiness = new HashMap<String, Boolean>();
        this.connectionStringsToAdd = new HashMap<String, ConnStringValueTypePair>();
        this.connectionStringsToRemove = new ArrayList<String>();
        this.connectionStringStickiness = new HashMap<String, Boolean>();
        this.sourceControl = null;
        this.sourceControlToDelete = false;
        this.authenticationToUpdate = false;
        this.sslBindingsToCreate = new TreeMap();
        this.msiHandler = null;
        if (((SiteInner)((Object)this.inner())).hostNames() != null) {
            this.hostNamesSet = Sets.newHashSet(((SiteInner)((Object)this.inner())).hostNames());
        }
        if (((SiteInner)((Object)this.inner())).enabledHostNames() != null) {
            this.enabledHostNamesSet = Sets.newHashSet(((SiteInner)((Object)this.inner())).enabledHostNames());
        }
        if (((SiteInner)((Object)this.inner())).trafficManagerHostNames() != null) {
            this.trafficManagerHostNamesSet = Sets.newHashSet(((SiteInner)((Object)this.inner())).trafficManagerHostNames());
        }
        if (((SiteInner)((Object)this.inner())).outboundIpAddresses() != null) {
            this.outboundIPAddressesSet = Sets.newHashSet((Object[])((SiteInner)((Object)this.inner())).outboundIpAddresses().split(",[ ]*"));
        }
        this.hostNameSslStateMap = new HashMap<String, HostNameSslState>();
        if (((SiteInner)((Object)this.inner())).hostNameSslStates() != null) {
            for (HostNameSslState hostNameSslState : ((SiteInner)((Object)this.inner())).hostNameSslStates()) {
                if (hostNameSslState.sslState() == null) {
                    hostNameSslState.withSslState(SslState.DISABLED);
                }
                this.hostNameSslStateMap.put(hostNameSslState.name(), hostNameSslState);
            }
        }
        return (FluentT)this;
    }

    @Override
    public String state() {
        return ((SiteInner)((Object)this.inner())).state();
    }

    @Override
    public Set<String> hostNames() {
        return Collections.unmodifiableSet(this.hostNamesSet);
    }

    @Override
    public String repositorySiteName() {
        return ((SiteInner)((Object)this.inner())).repositorySiteName();
    }

    @Override
    public UsageState usageState() {
        return ((SiteInner)((Object)this.inner())).usageState();
    }

    @Override
    public boolean enabled() {
        return ((SiteInner)((Object)this.inner())).enabled();
    }

    @Override
    public Set<String> enabledHostNames() {
        if (this.enabledHostNamesSet == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.enabledHostNamesSet);
    }

    @Override
    public SiteAvailabilityState availabilityState() {
        return ((SiteInner)((Object)this.inner())).availabilityState();
    }

    @Override
    public Map<String, HostNameSslState> hostNameSslStates() {
        return Collections.unmodifiableMap(this.hostNameSslStateMap);
    }

    @Override
    public String appServicePlanId() {
        return ((SiteInner)((Object)this.inner())).serverFarmId();
    }

    @Override
    public DateTime lastModifiedTime() {
        return ((SiteInner)((Object)this.inner())).lastModifiedTimeUtc();
    }

    @Override
    public Set<String> trafficManagerHostNames() {
        return Collections.unmodifiableSet(this.trafficManagerHostNamesSet);
    }

    @Override
    public boolean scmSiteAlsoStopped() {
        return ((SiteInner)((Object)this.inner())).scmSiteAlsoStopped();
    }

    @Override
    public String targetSwapSlot() {
        return ((SiteInner)((Object)this.inner())).targetSwapSlot();
    }

    @Override
    public boolean clientAffinityEnabled() {
        return ((SiteInner)((Object)this.inner())).clientAffinityEnabled();
    }

    @Override
    public boolean clientCertEnabled() {
        return ((SiteInner)((Object)this.inner())).clientCertEnabled();
    }

    @Override
    public boolean hostNamesDisabled() {
        return Utils.toPrimitiveBoolean((Boolean)((SiteInner)((Object)this.inner())).hostNamesDisabled());
    }

    @Override
    public Set<String> outboundIPAddresses() {
        return Collections.unmodifiableSet(this.outboundIPAddressesSet);
    }

    @Override
    public int containerSize() {
        return Utils.toPrimitiveInt((Integer)((SiteInner)((Object)this.inner())).containerSize());
    }

    @Override
    public CloningInfo cloningInfo() {
        return ((SiteInner)((Object)this.inner())).cloningInfo();
    }

    @Override
    public boolean isDefaultContainer() {
        return ((SiteInner)((Object)this.inner())).isDefaultContainer();
    }

    @Override
    public String defaultHostName() {
        if (((SiteInner)((Object)this.inner())).defaultHostName() != null) {
            return ((SiteInner)((Object)this.inner())).defaultHostName();
        }
        return "http://" + this.name() + ".azurewebsites.net";
    }

    @Override
    public List<String> defaultDocuments() {
        if (this.siteConfig == null) {
            return null;
        }
        return Collections.unmodifiableList(this.siteConfig.defaultDocuments());
    }

    @Override
    public NetFrameworkVersion netFrameworkVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return NetFrameworkVersion.fromString(this.siteConfig.netFrameworkVersion());
    }

    @Override
    public PhpVersion phpVersion() {
        if (this.siteConfig == null || this.siteConfig.phpVersion() == null) {
            return PhpVersion.OFF;
        }
        return PhpVersion.fromString(this.siteConfig.phpVersion());
    }

    @Override
    public PythonVersion pythonVersion() {
        if (this.siteConfig == null || this.siteConfig.pythonVersion() == null) {
            return PythonVersion.OFF;
        }
        return PythonVersion.fromString(this.siteConfig.pythonVersion());
    }

    @Override
    public String nodeVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.nodeVersion();
    }

    @Override
    public boolean remoteDebuggingEnabled() {
        if (this.siteConfig == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)this.siteConfig.remoteDebuggingEnabled());
    }

    @Override
    public RemoteVisualStudioVersion remoteDebuggingVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return RemoteVisualStudioVersion.fromString(this.siteConfig.remoteDebuggingVersion());
    }

    @Override
    public boolean webSocketsEnabled() {
        if (this.siteConfig == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)this.siteConfig.webSocketsEnabled());
    }

    @Override
    public boolean alwaysOn() {
        if (this.siteConfig == null) {
            return false;
        }
        return Utils.toPrimitiveBoolean((Boolean)this.siteConfig.alwaysOn());
    }

    @Override
    public JavaVersion javaVersion() {
        if (this.siteConfig == null || this.siteConfig.javaVersion() == null) {
            return JavaVersion.OFF;
        }
        return JavaVersion.fromString(this.siteConfig.javaVersion());
    }

    @Override
    public String javaContainer() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.javaContainer();
    }

    @Override
    public String javaContainerVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.javaContainerVersion();
    }

    @Override
    public ManagedPipelineMode managedPipelineMode() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.managedPipelineMode();
    }

    @Override
    public PlatformArchitecture platformArchitecture() {
        if (this.siteConfig.use32BitWorkerProcess().booleanValue()) {
            return PlatformArchitecture.X86;
        }
        return PlatformArchitecture.X64;
    }

    @Override
    public String linuxFxVersion() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.linuxFxVersion();
    }

    @Override
    public String autoSwapSlotName() {
        if (this.siteConfig == null) {
            return null;
        }
        return this.siteConfig.autoSwapSlotName();
    }

    @Override
    public OperatingSystem operatingSystem() {
        if (((SiteInner)((Object)this.inner())).kind() != null && ((SiteInner)((Object)this.inner())).kind().toLowerCase().contains("linux")) {
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.WINDOWS;
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((SiteInner)((Object)this.inner())).identity() == null) {
            return null;
        }
        return ((SiteInner)((Object)this.inner())).identity().tenantId();
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((SiteInner)((Object)this.inner())).identity() == null) {
            return null;
        }
        return ((SiteInner)((Object)this.inner())).identity().principalId();
    }

    @Override
    public Map<String, AppSetting> getAppSettings() {
        return (Map)this.getAppSettingsAsync().toBlocking().single();
    }

    @Override
    public Observable<Map<String, AppSetting>> getAppSettingsAsync() {
        return Observable.zip(this.listAppSettings(), this.listSlotConfigurations(), (Func2)new Func2<StringDictionaryInner, SlotConfigNamesResourceInner, Map<String, AppSetting>>(){

            public Map<String, AppSetting> call(final StringDictionaryInner appSettingsInner, final SlotConfigNamesResourceInner slotConfigs) {
                if (appSettingsInner == null || appSettingsInner.properties() == null) {
                    return null;
                }
                return Maps.asMap(appSettingsInner.properties().keySet(), (Function)new Function<String, AppSetting>(){

                    public AppSetting apply(String input) {
                        return new AppSettingImpl(input, appSettingsInner.properties().get(input), slotConfigs != null && slotConfigs.appSettingNames() != null && slotConfigs.appSettingNames().contains(input));
                    }
                });
            }
        });
    }

    @Override
    public Map<String, ConnectionString> getConnectionStrings() {
        return (Map)this.getConnectionStringsAsync().toBlocking().single();
    }

    @Override
    public Observable<Map<String, ConnectionString>> getConnectionStringsAsync() {
        return Observable.zip(this.listConnectionStrings(), this.listSlotConfigurations(), (Func2)new Func2<ConnectionStringDictionaryInner, SlotConfigNamesResourceInner, Map<String, ConnectionString>>(){

            public Map<String, ConnectionString> call(final ConnectionStringDictionaryInner connectionStringsInner, final SlotConfigNamesResourceInner slotConfigs) {
                if (connectionStringsInner == null || connectionStringsInner.properties() == null) {
                    return null;
                }
                return Maps.asMap(connectionStringsInner.properties().keySet(), (Function)new Function<String, ConnectionString>(){

                    public ConnectionString apply(String input) {
                        return new ConnectionStringImpl(input, connectionStringsInner.properties().get(input), slotConfigs != null && slotConfigs.connectionStringNames() != null && slotConfigs.connectionStringNames().contains(input));
                    }
                });
            }
        });
    }

    @Override
    public WebAppAuthentication getAuthenticationConfig() {
        return (WebAppAuthentication)this.getAuthenticationConfigAsync().toBlocking().single();
    }

    @Override
    public Observable<WebAppAuthentication> getAuthenticationConfigAsync() {
        return this.getAuthentication().map((Func1)new Func1<SiteAuthSettingsInner, WebAppAuthentication>(){

            public WebAppAuthentication call(SiteAuthSettingsInner siteAuthSettingsInner) {
                return new WebAppAuthenticationImpl(siteAuthSettingsInner, WebAppBaseImpl.this);
            }
        });
    }

    abstract Observable<SiteInner> createOrUpdateInner(SiteInner var1);

    abstract Observable<SiteInner> getInner();

    abstract Observable<SiteConfigResourceInner> getConfigInner();

    abstract Observable<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner var1);

    abstract Observable<Void> deleteHostNameBinding(String var1);

    abstract Observable<StringDictionaryInner> listAppSettings();

    abstract Observable<StringDictionaryInner> updateAppSettings(StringDictionaryInner var1);

    abstract Observable<ConnectionStringDictionaryInner> listConnectionStrings();

    abstract Observable<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner var1);

    abstract Observable<SlotConfigNamesResourceInner> listSlotConfigurations();

    abstract Observable<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner var1);

    abstract Observable<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner var1);

    abstract Observable<Void> deleteSourceControl();

    abstract Observable<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner var1);

    abstract Observable<SiteAuthSettingsInner> getAuthentication();

    abstract Observable<MSDeployStatusInner> createMSDeploy(MSDeployInner var1);

    abstract Observable<SiteLogsConfigInner> updateDiagnosticLogsConfig(SiteLogsConfigInner var1);

    public void beforeGroupCreateOrUpdate() {
        if (this.hostNameSslStateMap.size() > 0) {
            ((SiteInner)((Object)this.inner())).withHostNameSslStates(new ArrayList<HostNameSslState>(this.hostNameSslStateMap.values()));
        }
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return WebAppBaseImpl.this.submitHostNameBindings().flatMap(new Func1<FluentT, Observable<Indexable>>(){

                    public Observable<Indexable> call(FluentT fluentT) {
                        return WebAppBaseImpl.this.submitSslBindings((SiteInner)((Object)fluentT.inner()));
                    }
                });
            }
        });
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return WebAppBaseImpl.this.submitSiteConfig();
            }
        });
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return WebAppBaseImpl.this.submitAppSettings().mergeWith(WebAppBaseImpl.this.submitConnectionStrings()).last().flatMap((Func1)new Func1<Indexable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Indexable indexable) {
                        return WebAppBaseImpl.this.submitStickiness();
                    }
                });
            }
        });
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return WebAppBaseImpl.this.submitSourceControlToDelete().flatMap((Func1)new Func1<Indexable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Indexable indexable) {
                        return WebAppBaseImpl.this.submitSourceControlToCreate();
                    }
                });
            }
        });
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return WebAppBaseImpl.this.submitAuthentication();
            }
        });
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return WebAppBaseImpl.this.submitLogConfiguration();
            }
        });
        if (this.msiHandler != null) {
            this.addPostRunDependent(this.msiHandler);
        }
    }

    public Observable<FluentT> createResourceAsync() {
        return this.submitSite((SiteInner)((Object)this.inner())).map(new Func1<SiteInner, FluentT>(){

            public FluentT call(SiteInner siteInner) {
                WebAppBaseImpl.this.setInner(siteInner);
                return WebAppBaseImpl.this;
            }
        });
    }

    public Completable afterPostRunAsync(boolean succeeded) {
        if (succeeded) {
            this.isInCreateMode = false;
        }
        return Completable.fromAction((Action0)new Action0(){

            public void call() {
                WebAppBaseImpl.this.normalizeProperties();
            }
        });
    }

    Observable<SiteInner> submitSite(final SiteInner site) {
        site.withSiteConfig(new SiteConfig());
        return this.createOrUpdateInner(site).map((Func1)new Func1<SiteInner, SiteInner>(){

            public SiteInner call(SiteInner siteInner) {
                site.withSiteConfig(null);
                return siteInner;
            }
        });
    }

    Observable<FluentT> submitHostNameBindings() {
        ArrayList<Observable> bindingObservables = new ArrayList<Observable>();
        for (HostNameBindingImpl<FluentT, FluentImplT> hostNameBindingImpl : this.hostNameBindingsToCreate.values()) {
            bindingObservables.add(Utils.rootResource(hostNameBindingImpl.createAsync()));
        }
        for (String string : this.hostNameBindingsToDelete) {
            bindingObservables.add(this.deleteHostNameBinding(string).map((Func1)new Func1<Object, HostNameBinding>(){

                public HostNameBinding call(Object o) {
                    return null;
                }
            }));
        }
        if (bindingObservables.isEmpty()) {
            return Observable.just((Object)this);
        }
        return Observable.zip(bindingObservables, (FuncN)new FuncN<WebAppBaseImpl>(){

            public WebAppBaseImpl call(Object ... args) {
                return WebAppBaseImpl.this;
            }
        }).flatMap(new Func1<WebAppBaseImpl, Observable<FluentT>>(){

            public Observable<FluentT> call(WebAppBaseImpl webAppBase) {
                return webAppBase.refreshAsync();
            }
        });
    }

    Observable<Indexable> submitSslBindings(final SiteInner site) {
        ArrayList<Observable<AppServiceCertificate>> certs = new ArrayList<Observable<AppServiceCertificate>>();
        for (HostNameSslBindingImpl<FluentT, FluentImplT> binding : this.sslBindingsToCreate.values()) {
            certs.add(binding.newCertificate());
            this.hostNameSslStateMap.put(((HostNameSslState)binding.inner()).name(), ((HostNameSslState)binding.inner()).withToUpdate(true));
        }
        if (certs.isEmpty()) {
            return Observable.just((Object)this);
        }
        site.withHostNameSslStates(new ArrayList<HostNameSslState>(this.hostNameSslStateMap.values()));
        return Observable.zip(certs, (FuncN)new FuncN<SiteInner>(){

            public SiteInner call(Object ... args) {
                return site;
            }
        }).flatMap((Func1)new Func1<SiteInner, Observable<SiteInner>>(){

            public Observable<SiteInner> call(SiteInner inner) {
                return WebAppBaseImpl.this.createOrUpdateInner(inner);
            }
        }).map((Func1)new Func1<SiteInner, Indexable>(){

            public Indexable call(SiteInner siteInner) {
                WebAppBaseImpl.this.setInner(siteInner);
                return WebAppBaseImpl.this;
            }
        });
    }

    Observable<Indexable> submitSiteConfig() {
        if (this.siteConfig == null) {
            return Observable.just((Object)this);
        }
        return this.createOrUpdateSiteConfig(this.siteConfig).flatMap((Func1)new Func1<SiteConfigResourceInner, Observable<Indexable>>(){

            public Observable<Indexable> call(SiteConfigResourceInner returnedSiteConfig) {
                WebAppBaseImpl.this.siteConfig = returnedSiteConfig;
                return Observable.just((Object)WebAppBaseImpl.this);
            }
        });
    }

    Observable<Indexable> submitAppSettings() {
        Observable observable = Observable.just((Object)this);
        if (!this.appSettingsToAdd.isEmpty() || !this.appSettingsToRemove.isEmpty()) {
            observable = this.listAppSettings().flatMap((Func1)new Func1<StringDictionaryInner, Observable<StringDictionaryInner>>(){

                public Observable<StringDictionaryInner> call(StringDictionaryInner stringDictionaryInner) {
                    if (stringDictionaryInner == null) {
                        stringDictionaryInner = new StringDictionaryInner();
                    }
                    if (stringDictionaryInner.properties() == null) {
                        stringDictionaryInner.withProperties(new HashMap<String, String>());
                    }
                    for (String appSettingKey : WebAppBaseImpl.this.appSettingsToRemove) {
                        stringDictionaryInner.properties().remove(appSettingKey);
                    }
                    stringDictionaryInner.properties().putAll(WebAppBaseImpl.this.appSettingsToAdd);
                    return WebAppBaseImpl.this.updateAppSettings(stringDictionaryInner);
                }
            }).map((Func1)new Func1<StringDictionaryInner, Indexable>(){

                public Indexable call(StringDictionaryInner stringDictionaryInner) {
                    return WebAppBaseImpl.this;
                }
            });
        }
        return observable;
    }

    Observable<Indexable> submitConnectionStrings() {
        Observable observable = Observable.just((Object)this);
        if (!this.connectionStringsToAdd.isEmpty() || !this.connectionStringsToRemove.isEmpty()) {
            observable = this.listConnectionStrings().flatMap((Func1)new Func1<ConnectionStringDictionaryInner, Observable<ConnectionStringDictionaryInner>>(){

                public Observable<ConnectionStringDictionaryInner> call(ConnectionStringDictionaryInner dictionaryInner) {
                    if (dictionaryInner == null) {
                        dictionaryInner = new ConnectionStringDictionaryInner();
                    }
                    if (dictionaryInner.properties() == null) {
                        dictionaryInner.withProperties(new HashMap<String, ConnStringValueTypePair>());
                    }
                    for (String connectionString : WebAppBaseImpl.this.connectionStringsToRemove) {
                        dictionaryInner.properties().remove(connectionString);
                    }
                    dictionaryInner.properties().putAll(WebAppBaseImpl.this.connectionStringsToAdd);
                    return WebAppBaseImpl.this.updateConnectionStrings(dictionaryInner);
                }
            }).map((Func1)new Func1<ConnectionStringDictionaryInner, Indexable>(){

                public Indexable call(ConnectionStringDictionaryInner stringDictionaryInner) {
                    return WebAppBaseImpl.this;
                }
            });
        }
        return observable;
    }

    Observable<Indexable> submitStickiness() {
        Observable observable = Observable.just((Object)this);
        if (!this.appSettingStickiness.isEmpty() || !this.connectionStringStickiness.isEmpty()) {
            observable = this.listSlotConfigurations().flatMap((Func1)new Func1<SlotConfigNamesResourceInner, Observable<SlotConfigNamesResourceInner>>(){

                public Observable<SlotConfigNamesResourceInner> call(SlotConfigNamesResourceInner slotConfigNamesResourceInner) {
                    if (slotConfigNamesResourceInner == null) {
                        slotConfigNamesResourceInner = new SlotConfigNamesResourceInner();
                    }
                    if (slotConfigNamesResourceInner.appSettingNames() == null) {
                        slotConfigNamesResourceInner.withAppSettingNames(new ArrayList<String>());
                    }
                    if (slotConfigNamesResourceInner.connectionStringNames() == null) {
                        slotConfigNamesResourceInner.withConnectionStringNames(new ArrayList<String>());
                    }
                    HashSet<String> stickyAppSettingKeys = new HashSet<String>(slotConfigNamesResourceInner.appSettingNames());
                    HashSet<String> stickyConnectionStringNames = new HashSet<String>(slotConfigNamesResourceInner.connectionStringNames());
                    for (Map.Entry stickiness : WebAppBaseImpl.this.appSettingStickiness.entrySet()) {
                        if (((Boolean)stickiness.getValue()).booleanValue()) {
                            stickyAppSettingKeys.add((String)stickiness.getKey());
                            continue;
                        }
                        stickyAppSettingKeys.remove(stickiness.getKey());
                    }
                    for (Map.Entry stickiness : WebAppBaseImpl.this.connectionStringStickiness.entrySet()) {
                        if (((Boolean)stickiness.getValue()).booleanValue()) {
                            stickyConnectionStringNames.add((String)stickiness.getKey());
                            continue;
                        }
                        stickyConnectionStringNames.remove(stickiness.getKey());
                    }
                    slotConfigNamesResourceInner.withAppSettingNames(new ArrayList<String>(stickyAppSettingKeys));
                    slotConfigNamesResourceInner.withConnectionStringNames(new ArrayList<String>(stickyConnectionStringNames));
                    return WebAppBaseImpl.this.updateSlotConfigurations(slotConfigNamesResourceInner);
                }
            }).map((Func1)new Func1<SlotConfigNamesResourceInner, Indexable>(){

                public Indexable call(SlotConfigNamesResourceInner slotConfigNamesResourceInner) {
                    return WebAppBaseImpl.this;
                }
            });
        }
        return observable;
    }

    Observable<Indexable> submitSourceControlToCreate() {
        if (this.sourceControl == null || this.sourceControlToDelete) {
            return Observable.just((Object)this);
        }
        return this.sourceControl.registerGithubAccessToken().flatMap((Func1)new Func1<SourceControlInner, Observable<SiteSourceControlInner>>(){

            public Observable<SiteSourceControlInner> call(SourceControlInner sourceControlInner) {
                return WebAppBaseImpl.this.createOrUpdateSourceControl((SiteSourceControlInner)WebAppBaseImpl.this.sourceControl.inner());
            }
        }).delay((Func1)new Func1<SiteSourceControlInner, Observable<Long>>(){

            public Observable<Long> call(SiteSourceControlInner siteSourceControlInner) {
                return Observable.fromCallable((Callable)new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        SdkContext.sleep((int)30000);
                        return 30000L;
                    }
                });
            }
        }).map((Func1)new Func1<SiteSourceControlInner, Indexable>(){

            public Indexable call(SiteSourceControlInner siteSourceControlInner) {
                return WebAppBaseImpl.this;
            }
        });
    }

    Observable<Indexable> submitSourceControlToDelete() {
        if (!this.sourceControlToDelete) {
            return Observable.just((Object)this);
        }
        return this.deleteSourceControl().map((Func1)new Func1<Void, Indexable>(){

            public Indexable call(Void aVoid) {
                return WebAppBaseImpl.this;
            }
        });
    }

    Observable<Indexable> submitAuthentication() {
        if (!this.authenticationToUpdate) {
            return Observable.just((Object)this);
        }
        return this.updateAuthentication((SiteAuthSettingsInner)this.authentication.inner()).map((Func1)new Func1<SiteAuthSettingsInner, Indexable>(){

            public Indexable call(SiteAuthSettingsInner siteAuthSettingsInner) {
                return WebAppBaseImpl.this;
            }
        });
    }

    Observable<Indexable> submitLogConfiguration() {
        if (this.siteLogsConfig == null) {
            return Observable.just((Object)this);
        }
        return this.updateDiagnosticLogsConfig(this.siteLogsConfig).map((Func1)new Func1<SiteLogsConfigInner, Indexable>(){

            public Indexable call(SiteLogsConfigInner siteLogsConfigInner) {
                WebAppBaseImpl.this.siteLogsConfig = null;
                return WebAppBaseImpl.this;
            }
        });
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> deploy() {
        return new WebDeploymentImpl(this);
    }

    WebAppBaseImpl<FluentT, FluentImplT> withNewHostNameSslBinding(HostNameSslBindingImpl<FluentT, FluentImplT> hostNameSslBinding) {
        if (hostNameSslBinding.newCertificate() != null) {
            this.sslBindingsToCreate.put(hostNameSslBinding.name(), hostNameSslBinding);
        }
        return this;
    }

    public FluentImplT withManagedHostnameBindings(AppServiceDomain domain, String ... hostnames) {
        for (String hostname : hostnames) {
            if (hostname.equals("@") || hostname.equalsIgnoreCase(domain.name())) {
                ((HostNameBindingImpl)((HostNameBindingImpl)((HostNameBindingImpl)((HostNameBindingImpl)this.defineHostnameBinding()).withAzureManagedDomain(domain)).withSubDomain(hostname)).withDnsRecordType(CustomHostNameDnsRecordType.A)).attach();
                continue;
            }
            ((HostNameBindingImpl)((HostNameBindingImpl)((HostNameBindingImpl)((HostNameBindingImpl)this.defineHostnameBinding()).withAzureManagedDomain(domain)).withSubDomain(hostname)).withDnsRecordType(CustomHostNameDnsRecordType.CNAME)).attach();
        }
        return (FluentImplT)this;
    }

    public HostNameBindingImpl<FluentT, FluentImplT> defineHostnameBinding() {
        HostNameBindingInner inner = new HostNameBindingInner();
        inner.withSiteName(this.name());
        inner.withAzureResourceType(AzureResourceType.WEBSITE);
        inner.withAzureResourceName(this.name());
        inner.withHostNameType(HostNameType.VERIFIED);
        return new HostNameBindingImpl(inner, this);
    }

    public FluentImplT withThirdPartyHostnameBinding(String domain, String ... hostnames) {
        for (String hostname : hostnames) {
            ((HostNameBindingImpl)((HostNameBindingImpl)((HostNameBindingImpl)((HostNameBindingImpl)this.defineHostnameBinding()).withThirdPartyDomain(domain)).withSubDomain(hostname)).withDnsRecordType(CustomHostNameDnsRecordType.CNAME)).attach();
        }
        return (FluentImplT)this;
    }

    public FluentImplT withoutHostnameBinding(String hostname) {
        this.hostNameBindingsToDelete.add(hostname);
        return (FluentImplT)this;
    }

    public FluentImplT withoutSslBinding(String hostname) {
        if (this.hostNameSslStateMap.containsKey(hostname)) {
            this.hostNameSslStateMap.get(hostname).withSslState(SslState.DISABLED).withToUpdate(true);
        }
        return (FluentImplT)this;
    }

    FluentImplT withHostNameBinding(HostNameBindingImpl<FluentT, FluentImplT> hostNameBinding) {
        this.hostNameBindingsToCreate.put(hostNameBinding.name(), hostNameBinding);
        return (FluentImplT)this;
    }

    public FluentImplT withAppDisabledOnCreation() {
        ((SiteInner)((Object)this.inner())).withEnabled(false);
        return (FluentImplT)this;
    }

    public FluentImplT withScmSiteAlsoStopped(boolean scmSiteAlsoStopped) {
        ((SiteInner)((Object)this.inner())).withScmSiteAlsoStopped(scmSiteAlsoStopped);
        return (FluentImplT)this;
    }

    public FluentImplT withClientAffinityEnabled(boolean enabled) {
        ((SiteInner)((Object)this.inner())).withClientAffinityEnabled(enabled);
        return (FluentImplT)this;
    }

    public FluentImplT withClientCertEnabled(boolean enabled) {
        ((SiteInner)((Object)this.inner())).withClientCertEnabled(enabled);
        return (FluentImplT)this;
    }

    public HostNameSslBindingImpl<FluentT, FluentImplT> defineSslBinding() {
        return new HostNameSslBindingImpl(new HostNameSslState(), this);
    }

    public FluentImplT withNetFrameworkVersion(NetFrameworkVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withNetFrameworkVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withPhpVersion(PhpVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withPhpVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withoutPhp() {
        return (FluentImplT)this.withPhpVersion(PhpVersion.fromString(""));
    }

    public FluentImplT withJavaVersion(JavaVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withJavaVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withoutJava() {
        return (FluentImplT)((WebAppBaseImpl)this.withJavaVersion(JavaVersion.fromString(""))).withWebContainer(null);
    }

    public FluentImplT withWebContainer(WebContainer webContainer) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (webContainer == null) {
            this.siteConfig.withJavaContainer(null);
            this.siteConfig.withJavaContainerVersion(null);
        } else {
            String[] containerInfo = webContainer.toString().split(" ");
            this.siteConfig.withJavaContainer(containerInfo[0]);
            this.siteConfig.withJavaContainerVersion(containerInfo[1]);
        }
        return (FluentImplT)this;
    }

    public FluentImplT withPythonVersion(PythonVersion version) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withPythonVersion(version.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withoutPython() {
        return (FluentImplT)this.withPythonVersion(PythonVersion.fromString(""));
    }

    public FluentImplT withPlatformArchitecture(PlatformArchitecture platform) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withUse32BitWorkerProcess(platform.equals((Object)PlatformArchitecture.X86));
        return (FluentImplT)this;
    }

    public FluentImplT withWebSocketsEnabled(boolean enabled) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withWebSocketsEnabled(enabled);
        return (FluentImplT)this;
    }

    public FluentImplT withWebAppAlwaysOn(boolean alwaysOn) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAlwaysOn(alwaysOn);
        return (FluentImplT)this;
    }

    public FluentImplT withManagedPipelineMode(ManagedPipelineMode managedPipelineMode) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withManagedPipelineMode(managedPipelineMode);
        return (FluentImplT)this;
    }

    public FluentImplT withAutoSwapSlotName(String slotName) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withAutoSwapSlotName(slotName);
        return (FluentImplT)this;
    }

    public FluentImplT withRemoteDebuggingEnabled(RemoteVisualStudioVersion remoteVisualStudioVersion) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withRemoteDebuggingEnabled(true);
        this.siteConfig.withRemoteDebuggingVersion(remoteVisualStudioVersion.toString());
        return (FluentImplT)this;
    }

    public FluentImplT withRemoteDebuggingDisabled() {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withRemoteDebuggingEnabled(false);
        return (FluentImplT)this;
    }

    public FluentImplT withDefaultDocument(String document) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.defaultDocuments() == null) {
            this.siteConfig.withDefaultDocuments(new ArrayList<String>());
        }
        this.siteConfig.defaultDocuments().add(document);
        return (FluentImplT)this;
    }

    public FluentImplT withDefaultDocuments(List<String> documents) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.defaultDocuments() == null) {
            this.siteConfig.withDefaultDocuments(new ArrayList<String>());
        }
        this.siteConfig.defaultDocuments().addAll(documents);
        return (FluentImplT)this;
    }

    public FluentImplT withoutDefaultDocument(String document) {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        if (this.siteConfig.defaultDocuments() != null) {
            this.siteConfig.defaultDocuments().remove(document);
        }
        return (FluentImplT)this;
    }

    public FluentImplT withAppSetting(String key, String value) {
        this.appSettingsToAdd.put(key, value);
        return (FluentImplT)this;
    }

    public FluentImplT withAppSettings(Map<String, String> settings) {
        this.appSettingsToAdd.putAll(settings);
        return (FluentImplT)this;
    }

    public FluentImplT withStickyAppSetting(String key, String value) {
        this.withAppSetting(key, value);
        return (FluentImplT)this.withAppSettingStickiness(key, true);
    }

    public FluentImplT withStickyAppSettings(Map<String, String> settings) {
        this.withAppSettings((Map)settings);
        this.appSettingStickiness.putAll(Maps.asMap(settings.keySet(), (Function)new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return true;
            }
        }));
        return (FluentImplT)this;
    }

    public FluentImplT withoutAppSetting(String key) {
        this.appSettingsToRemove.add(key);
        this.appSettingStickiness.remove(key);
        return (FluentImplT)this;
    }

    public FluentImplT withAppSettingStickiness(String key, boolean sticky) {
        this.appSettingStickiness.put(key, sticky);
        return (FluentImplT)this;
    }

    public FluentImplT withConnectionString(String name, String value, ConnectionStringType type) {
        this.connectionStringsToAdd.put(name, new ConnStringValueTypePair().withValue(value).withType(type));
        return (FluentImplT)this;
    }

    public FluentImplT withStickyConnectionString(String name, String value, ConnectionStringType type) {
        this.connectionStringsToAdd.put(name, new ConnStringValueTypePair().withValue(value).withType(type));
        this.connectionStringStickiness.put(name, true);
        return (FluentImplT)this;
    }

    public FluentImplT withoutConnectionString(String name) {
        this.connectionStringsToRemove.add(name);
        this.connectionStringStickiness.remove(name);
        return (FluentImplT)this;
    }

    public FluentImplT withConnectionStringStickiness(String name, boolean stickiness) {
        this.connectionStringStickiness.put(name, stickiness);
        return (FluentImplT)this;
    }

    void withSourceControl(WebAppSourceControlImpl<FluentT, FluentImplT> sourceControl) {
        this.sourceControl = sourceControl;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> defineSourceControl() {
        SiteSourceControlInner sourceControlInner = new SiteSourceControlInner();
        return new WebAppSourceControlImpl(sourceControlInner, this);
    }

    public FluentImplT withLocalGitSourceControl() {
        if (this.siteConfig == null) {
            this.siteConfig = new SiteConfigResourceInner();
        }
        this.siteConfig.withScmType(ScmType.LOCAL_GIT);
        return (FluentImplT)this;
    }

    public FluentImplT withoutSourceControl() {
        this.sourceControlToDelete = true;
        return (FluentImplT)this;
    }

    void withAuthentication(WebAppAuthenticationImpl<FluentT, FluentImplT> authentication) {
        this.authentication = authentication;
        this.authenticationToUpdate = true;
    }

    public Observable<FluentT> refreshAsync() {
        return super.refreshAsync().flatMap(new Func1<FluentT, Observable<FluentT>>(){

            public Observable<FluentT> call(FluentT fluentT) {
                return WebAppBaseImpl.this.getConfigInner().map(new Func1<SiteConfigResourceInner, FluentT>((WebAppBase)fluentT){
                    final /* synthetic */ WebAppBase val$fluentT;
                    {
                        this.val$fluentT = webAppBase;
                    }

                    public FluentT call(SiteConfigResourceInner returnedSiteConfig) {
                        WebAppBaseImpl.this.siteConfig = returnedSiteConfig;
                        return this.val$fluentT;
                    }
                });
            }
        });
    }

    protected Observable<SiteInner> getInnerAsync() {
        return this.getInner();
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> defineAuthentication() {
        return new WebAppAuthenticationImpl(new SiteAuthSettingsInner().withEnabled(true), this);
    }

    public FluentImplT withoutAuthentication() {
        ((SiteAuthSettingsInner)this.authentication.inner()).withEnabled(false);
        this.authenticationToUpdate = true;
        return (FluentImplT)this;
    }

    public FluentImplT withContainerLoggingEnabled(int quotaInMB, int retentionDays) {
        this.siteLogsConfig = new SiteLogsConfigInner().withHttpLogs(new HttpLogsConfig().withFileSystem(new FileSystemHttpLogsConfig().withEnabled(true).withRetentionInMb(quotaInMB).withRetentionInDays(retentionDays)));
        return (FluentImplT)this;
    }

    public FluentImplT withContainerLoggingEnabled() {
        return (FluentImplT)this.withContainerLoggingEnabled(35, 0);
    }

    public FluentImplT withContainerLoggingDisabled() {
        this.siteLogsConfig = new SiteLogsConfigInner().withHttpLogs(new HttpLogsConfig().withFileSystem(new FileSystemHttpLogsConfig().withEnabled(false)));
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedManagedServiceIdentity() {
        ((SiteInner)((Object)this.inner())).withIdentity(new ManagedServiceIdentity().withType("SystemAssigned"));
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessTo(final String resourceId, final BuiltInRole role) {
        if (((SiteInner)((Object)this.inner())).identity() == null || ((SiteInner)((Object)this.inner())).identity().type() == null) {
            throw new IllegalArgumentException("The web app must be assigned with Managed Service Identity.");
        }
        this.msiHandler = new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((RoleAssignment.DefinitionStages.Blank)((AppServiceManager)WebAppBaseImpl.this.manager()).rbacManager().roleAssignments().define(SdkContext.randomUuid())).forObjectId(WebAppBaseImpl.this.systemAssignedManagedServiceIdentityPrincipalId()).withBuiltInRole(role).withScope(resourceId).createAsync();
            }
        };
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(final BuiltInRole role) {
        if (((SiteInner)((Object)this.inner())).identity() == null || ((SiteInner)((Object)this.inner())).identity().type() == null) {
            throw new IllegalArgumentException("The web app must be assigned with Managed Service Identity.");
        }
        this.msiHandler = new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((RoleAssignment.DefinitionStages.Blank)((AppServiceManager)WebAppBaseImpl.this.manager()).rbacManager().roleAssignments().define(SdkContext.randomUuid())).forObjectId(WebAppBaseImpl.this.systemAssignedManagedServiceIdentityPrincipalId()).withBuiltInRole(role).withScope(WebAppBaseImpl.resourceGroupId(WebAppBaseImpl.this.id())).createAsync();
            }
        };
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessTo(final String resourceId, final String roleDefinitionId) {
        if (((SiteInner)((Object)this.inner())).identity() == null || ((SiteInner)((Object)this.inner())).identity().type() == null) {
            throw new IllegalArgumentException("The web app must be assigned with Managed Service Identity.");
        }
        this.msiHandler = new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((RoleAssignment.DefinitionStages.Blank)((AppServiceManager)WebAppBaseImpl.this.manager()).rbacManager().roleAssignments().define(SdkContext.randomUuid())).forServicePrincipal(WebAppBaseImpl.this.systemAssignedManagedServiceIdentityPrincipalId()).withRoleDefinition(roleDefinitionId).withScope(resourceId).createAsync();
            }
        };
        return (FluentImplT)this;
    }

    public FluentImplT withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(final String roleDefinitionId) {
        if (((SiteInner)((Object)this.inner())).identity() == null || ((SiteInner)((Object)this.inner())).identity().type() == null) {
            throw new IllegalArgumentException("The web app must be assigned with Managed Service Identity.");
        }
        this.msiHandler = new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((RoleAssignment.DefinitionStages.Blank)((AppServiceManager)WebAppBaseImpl.this.manager()).rbacManager().roleAssignments().define(SdkContext.randomUuid())).forServicePrincipal(WebAppBaseImpl.this.systemAssignedManagedServiceIdentityPrincipalId()).withRoleDefinition(roleDefinitionId).withScope(WebAppBaseImpl.resourceGroupId(WebAppBaseImpl.this.id())).createAsync();
            }
        };
        return (FluentImplT)this;
    }

    private static String resourceGroupId(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return String.format("/subscriptions/%s/resourceGroups/%s", resourceId.subscriptionId(), resourceId.resourceGroupName());
    }
}

