/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import java.util.List;

/**
 * Contains information about an application in a Batch account.
 */
public class ApplicationInner {
    /**
     * A string that uniquely identifies the application within the account.
     */
    private String id;

    /**
     * The display name for the application.
     */
    private String displayName;

    /**
     * The list of packages under this application.
     */
    private List<ApplicationPackageInner> packages;

    /**
     * A value indicating whether packages within the application may be
     * overwritten using the same version string.
     */
    private Boolean allowUpdates;

    /**
     * The package to use if a client requests the application but does not
     * specify a version.
     */
    private String defaultVersion;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName value.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName value.
     *
     * @param displayName the displayName value to set
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the packages value.
     *
     * @return the packages value
     */
    public List<ApplicationPackageInner> packages() {
        return this.packages;
    }

    /**
     * Set the packages value.
     *
     * @param packages the packages value to set
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withPackages(List<ApplicationPackageInner> packages) {
        this.packages = packages;
        return this;
    }

    /**
     * Get the allowUpdates value.
     *
     * @return the allowUpdates value
     */
    public Boolean allowUpdates() {
        return this.allowUpdates;
    }

    /**
     * Set the allowUpdates value.
     *
     * @param allowUpdates the allowUpdates value to set
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withAllowUpdates(Boolean allowUpdates) {
        this.allowUpdates = allowUpdates;
        return this;
    }

    /**
     * Get the defaultVersion value.
     *
     * @return the defaultVersion value
     */
    public String defaultVersion() {
        return this.defaultVersion;
    }

    /**
     * Set the defaultVersion value.
     *
     * @param defaultVersion the defaultVersion value to set
     * @return the ApplicationInner object itself.
     */
    public ApplicationInner withDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

}
