/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;


/**
 * Parameters for an ApplicationOperations.UpdateApplication request.
 */
public class UpdateApplicationParametersInner {
    /**
     * A value indicating whether packages within the application may be
     * overwritten using the same version string.
     */
    private Boolean allowUpdates;

    /**
     * The package to use if a client requests the application but does not
     * specify a version.
     */
    private String defaultVersion;

    /**
     * The display name for the application.
     */
    private String displayName;

    /**
     * Get the allowUpdates value.
     *
     * @return the allowUpdates value
     */
    public Boolean allowUpdates() {
        return this.allowUpdates;
    }

    /**
     * Set the allowUpdates value.
     *
     * @param allowUpdates the allowUpdates value to set
     * @return the UpdateApplicationParametersInner object itself.
     */
    public UpdateApplicationParametersInner withAllowUpdates(Boolean allowUpdates) {
        this.allowUpdates = allowUpdates;
        return this;
    }

    /**
     * Get the defaultVersion value.
     *
     * @return the defaultVersion value
     */
    public String defaultVersion() {
        return this.defaultVersion;
    }

    /**
     * Set the defaultVersion value.
     *
     * @param defaultVersion the defaultVersion value to set
     * @return the UpdateApplicationParametersInner object itself.
     */
    public UpdateApplicationParametersInner withDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    /**
     * Get the displayName value.
     *
     * @return the displayName value
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName value.
     *
     * @param displayName the displayName value to set
     * @return the UpdateApplicationParametersInner object itself.
     */
    public UpdateApplicationParametersInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

}
