/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.batch.AccountKeyType;
import com.microsoft.azure.management.batch.Application;
import com.microsoft.azure.management.batch.AutoStorageProperties;
import com.microsoft.azure.management.batch.BatchAccountKeys;
import com.microsoft.azure.management.batch.ProvisioningState;
import com.microsoft.azure.management.batch.implementation.BatchAccountInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.resources.fluentcore.model.Wrapper;
import com.microsoft.azure.management.storage.StorageAccount;
import java.util.Map;

@Fluent
public interface BatchAccount
extends GroupableResource,
Refreshable<BatchAccount>,
Updatable<Update>,
Wrapper<BatchAccountInner> {
    public ProvisioningState provisioningState();

    public String accountEndpoint();

    public AutoStorageProperties autoStorage();

    public int coreQuota();

    public int poolQuota();

    public int activeJobAndJobScheduleQuota();

    public BatchAccountKeys getKeys();

    public BatchAccountKeys regenerateKeys(AccountKeyType var1);

    public void synchronizeAutoStorageKeys();

    public Map<String, Application> applications();

    public static interface UpdateStages {

        public static interface WithApplication {
            public Application.UpdateDefinitionStages.Blank<Update> defineNewApplication(String var1);

            public Application.Update updateApplication(String var1);

            public Update withoutApplication(String var1);
        }

        public static interface WithStorageAccount {
            public Update withExistingStorageAccount(StorageAccount var1);

            public Update withNewStorageAccount(Creatable<StorageAccount> var1);

            public Update withNewStorageAccount(String var1);

            public Update withoutStorageAccount();
        }
    }

    public static interface Update
    extends Appliable<BatchAccount>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithStorageAccount,
    UpdateStages.WithApplication {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<BatchAccount>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithCreateAndApplication
        extends WithCreate,
        WithApplicationAndStorage {
        }

        public static interface WithStorage {
            public WithCreate withExistingStorageAccount(StorageAccount var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);

            public WithCreate withNewStorageAccount(String var1);
        }

        public static interface WithApplication {
            public Application.DefinitionStages.Blank<WithApplicationAndStorage> defineNewApplication(String var1);
        }

        public static interface WithApplicationAndStorage
        extends WithStorage,
        WithApplication {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreateAndApplication> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate,
    DefinitionStages.WithApplicationAndStorage,
    DefinitionStages.WithCreateAndApplication,
    DefinitionStages.WithApplication,
    DefinitionStages.WithStorage {
    }
}

