/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batch.Application;
import com.microsoft.azure.management.batch.ApplicationPackage;
import com.microsoft.azure.management.batch.BatchAccount;
import com.microsoft.azure.management.batch.implementation.AddApplicationParametersInner;
import com.microsoft.azure.management.batch.implementation.ApplicationInner;
import com.microsoft.azure.management.batch.implementation.ApplicationPackageImpl;
import com.microsoft.azure.management.batch.implementation.ApplicationPackagesImpl;
import com.microsoft.azure.management.batch.implementation.ApplicationPackagesInner;
import com.microsoft.azure.management.batch.implementation.ApplicationsInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountImpl;
import com.microsoft.azure.management.batch.implementation.UpdateApplicationParametersInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ApplicationImpl
extends ExternalChildResourceImpl<Application, ApplicationInner, BatchAccountImpl, BatchAccount>
implements Application,
Application.Definition<BatchAccount.DefinitionStages.WithApplicationAndStorage>,
Application.UpdateDefinition<BatchAccount.Update>,
Application.Update {
    private final ApplicationsInner client;
    private final ApplicationPackagesImpl applicationPackages;

    protected ApplicationImpl(String name, BatchAccountImpl batchAccount, ApplicationInner inner, ApplicationsInner client, ApplicationPackagesInner applicationPackagesClient) {
        super(name, (Object)batchAccount, (Object)inner);
        this.client = client;
        this.applicationPackages = new ApplicationPackagesImpl(applicationPackagesClient, this);
    }

    public String id() {
        return ((ApplicationInner)this.inner()).id();
    }

    @Override
    public String displayName() {
        return ((ApplicationInner)this.inner()).displayName();
    }

    @Override
    public Map<String, ApplicationPackage> applicationPackages() {
        return this.applicationPackages.asMap();
    }

    @Override
    public boolean updatesAllowed() {
        return ((ApplicationInner)this.inner()).allowUpdates();
    }

    @Override
    public String defaultVersion() {
        return ((ApplicationInner)this.inner()).defaultVersion();
    }

    public Observable<Application> createAsync() {
        final ApplicationImpl self = this;
        AddApplicationParametersInner createParameter = new AddApplicationParametersInner();
        createParameter.withDisplayName(((ApplicationInner)this.inner()).displayName());
        createParameter.withAllowUpdates(((ApplicationInner)this.inner()).allowUpdates());
        return this.client.createAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), this.name(), createParameter).map((Func1)new Func1<ApplicationInner, Application>(){

            public Application call(ApplicationInner inner) {
                self.setInner(inner);
                return self;
            }
        }).flatMap((Func1)new Func1<Application, Observable<? extends Application>>(){

            public Observable<? extends Application> call(Application application) {
                return self.applicationPackages.commitAndGetAllAsync().map((Func1)new Func1<List<ApplicationPackageImpl>, Application>(){

                    public Application call(List<ApplicationPackageImpl> applications) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<Application> updateAsync() {
        final ApplicationImpl self = this;
        UpdateApplicationParametersInner updateParameter = new UpdateApplicationParametersInner();
        updateParameter.withDisplayName(((ApplicationInner)this.inner()).displayName());
        updateParameter.withAllowUpdates(((ApplicationInner)this.inner()).allowUpdates());
        return this.client.updateAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), this.name(), updateParameter).map((Func1)new Func1<Void, Application>(){

            public Application call(Void result) {
                return self;
            }
        }).flatMap((Func1)new Func1<Application, Observable<? extends Application>>(){

            public Observable<? extends Application> call(Application application) {
                return self.applicationPackages.commitAndGetAllAsync().map((Func1)new Func1<List<ApplicationPackageImpl>, Application>(){

                    public Application call(List<ApplicationPackageImpl> applications) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<Void> deleteAsync() {
        return this.client.deleteAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), this.name());
    }

    public Application refresh() {
        ApplicationInner inner = this.client.get(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), ((ApplicationInner)this.inner()).id());
        this.setInner(inner);
        this.applicationPackages.refresh();
        return this;
    }

    public BatchAccountImpl attach() {
        return ((BatchAccountImpl)this.parent()).withApplication(this);
    }

    @Override
    public ApplicationImpl withAllowUpdates(boolean allowUpdates) {
        ((ApplicationInner)this.inner()).withAllowUpdates(allowUpdates);
        return this;
    }

    @Override
    public ApplicationImpl withDisplayName(String displayName) {
        ((ApplicationInner)this.inner()).withDisplayName(displayName);
        return this;
    }

    protected static ApplicationImpl newApplication(String name, BatchAccountImpl parent, ApplicationsInner client, ApplicationPackagesInner applicationPackagesClient) {
        ApplicationInner inner = new ApplicationInner();
        inner.withId(name);
        ApplicationImpl applicationImpl = new ApplicationImpl(name, parent, inner, client, applicationPackagesClient);
        return applicationImpl;
    }

    @Override
    public Application.Update withoutApplicationPackage(String applicationPackageName) {
        this.applicationPackages.remove(applicationPackageName);
        return this;
    }

    ApplicationImpl withApplicationPackage(ApplicationPackageImpl applicationPackage) {
        this.applicationPackages.addApplicationPackage(applicationPackage);
        return this;
    }

    @Override
    public ApplicationImpl defineNewApplicationPackage(String applicationPackageName) {
        this.withApplicationPackage(this.applicationPackages.define(applicationPackageName));
        return this;
    }
}

