/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batch.BatchAccount;
import com.microsoft.azure.management.batch.BatchAccounts;
import com.microsoft.azure.management.batch.implementation.ApplicationPackagesInner;
import com.microsoft.azure.management.batch.implementation.ApplicationsInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountImpl;
import com.microsoft.azure.management.batch.implementation.BatchAccountInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountsInner;
import com.microsoft.azure.management.batch.implementation.BatchManager;
import com.microsoft.azure.management.batch.implementation.LocationsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import rx.Observable;

@LangDefinition
public class BatchAccountsImpl
extends GroupableResourcesImpl<BatchAccount, BatchAccountImpl, BatchAccountInner, BatchAccountsInner, BatchManager>
implements BatchAccounts {
    private final StorageManager storageManager;
    private ApplicationsInner applicationsClient;
    private ApplicationPackagesInner applicationPackagesClient;
    private LocationsInner locationClient;

    protected BatchAccountsImpl(BatchAccountsInner innerCollection, BatchManager manager, ApplicationsInner applicationsClient, ApplicationPackagesInner applicationPackagesClient, LocationsInner locationClient, StorageManager storageManager) {
        super((Object)innerCollection, (ManagerBase)manager);
        this.storageManager = storageManager;
        this.applicationsClient = applicationsClient;
        this.applicationPackagesClient = applicationPackagesClient;
        this.locationClient = locationClient;
    }

    public Observable<Void> deleteAsync(String groupName, String name) {
        return ((BatchAccountsInner)this.innerCollection).deleteAsync(groupName, name);
    }

    protected BatchAccountImpl wrapModel(String name) {
        BatchAccountInner inner = new BatchAccountInner();
        return new BatchAccountImpl(name, inner, (BatchAccountsInner)this.innerCollection, (BatchManager)this.myManager, this.applicationsClient, this.applicationPackagesClient, this.storageManager);
    }

    public PagedList<BatchAccount> list() {
        return this.wrapList(((BatchAccountsInner)this.innerCollection).list());
    }

    public PagedList<BatchAccount> listByGroup(String resourceGroupName) {
        return this.wrapList(((BatchAccountsInner)this.innerCollection).listByResourceGroup(resourceGroupName));
    }

    protected BatchAccountImpl wrapModel(BatchAccountInner inner) {
        return new BatchAccountImpl(inner.name(), inner, (BatchAccountsInner)this.innerCollection, (BatchManager)this.myManager, this.applicationsClient, this.applicationPackagesClient, this.storageManager);
    }

    public BatchAccount.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    public BatchAccount getByGroup(String groupName, String name) {
        return this.wrapModel(((BatchAccountsInner)this.innerCollection).get(groupName, name));
    }

    @Override
    public int getBatchAccountQuotaByLocation(Region region) {
        return this.locationClient.getQuotas(region.toString()).accountQuota();
    }
}

