/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.AccountKeyType;
import com.microsoft.azure.management.batch.BatchAccountRegenerateKeyParameters;
import com.microsoft.azure.management.batch.implementation.BatchAccountCreateParametersInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountKeysInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountUpdateParametersInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class BatchAccountsInner {
    private BatchAccountsService service;
    private BatchManagementClientImpl client;

    public BatchAccountsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (BatchAccountsService)retrofit.create(BatchAccountsService.class);
        this.client = client;
    }

    public BatchAccountInner create(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters) {
        return (BatchAccountInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().last()).getBody());
    }

    public ServiceCall<BatchAccountInner> createAsync(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters, ServiceCallback<BatchAccountInner> serviceCallback) {
        return ServiceCall.create(this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<BatchAccountInner> createAsync(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<BatchAccountInner>, BatchAccountInner>(){

            public BatchAccountInner call(ServiceResponse<BatchAccountInner> response) {
                return (BatchAccountInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<BatchAccountInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BatchAccountInner>(){}.getType());
    }

    public BatchAccountInner beginCreate(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters) {
        return (BatchAccountInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<BatchAccountInner> beginCreateAsync(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters, ServiceCallback<BatchAccountInner> serviceCallback) {
        return ServiceCall.create(this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<BatchAccountInner> beginCreateAsync(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<BatchAccountInner>, BatchAccountInner>(){

            public BatchAccountInner call(ServiceResponse<BatchAccountInner> response) {
                return (BatchAccountInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<BatchAccountInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String accountName, BatchAccountCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchAccountInner>>>(){

            public Observable<ServiceResponse<BatchAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchAccountInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<BatchAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BatchAccountInner update(String resourceGroupName, String accountName, BatchAccountUpdateParametersInner parameters) {
        return (BatchAccountInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).toBlocking().single()).getBody());
    }

    public ServiceCall<BatchAccountInner> updateAsync(String resourceGroupName, String accountName, BatchAccountUpdateParametersInner parameters, ServiceCallback<BatchAccountInner> serviceCallback) {
        return ServiceCall.create(this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters), serviceCallback);
    }

    public Observable<BatchAccountInner> updateAsync(String resourceGroupName, String accountName, BatchAccountUpdateParametersInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, parameters).map((Func1)new Func1<ServiceResponse<BatchAccountInner>, BatchAccountInner>(){

            public BatchAccountInner call(ServiceResponse<BatchAccountInner> response) {
                return (BatchAccountInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<BatchAccountInner>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, BatchAccountUpdateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, accountName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchAccountInner>>>(){

            public Observable<ServiceResponse<BatchAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchAccountInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<BatchAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().last()).getBody();
    }

    public ServiceCall<Void> deleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.deleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> beginDeleteAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).register(200, new TypeToken<Void>(){}.getType()).build(response);
    }

    public BatchAccountInner get(String resourceGroupName, String accountName) {
        return (BatchAccountInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).getBody());
    }

    public ServiceCall<BatchAccountInner> getAsync(String resourceGroupName, String accountName, ServiceCallback<BatchAccountInner> serviceCallback) {
        return ServiceCall.create(this.getWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<BatchAccountInner> getAsync(String resourceGroupName, String accountName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<BatchAccountInner>, BatchAccountInner>(){

            public BatchAccountInner call(ServiceResponse<BatchAccountInner> response) {
                return (BatchAccountInner)((Object)response.getBody());
            }
        });
    }

    public Observable<ServiceResponse<BatchAccountInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchAccountInner>>>(){

            public Observable<ServiceResponse<BatchAccountInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchAccountInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<BatchAccountInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BatchAccountInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<BatchAccountInner>((Page)response.getBody()){

            public Page<BatchAccountInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BatchAccountsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<BatchAccountInner>> listAsync(ListOperationCallback<BatchAccountInner> serviceCallback) {
        return AzureServiceCall.create(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(String nextPageLink) {
                return BatchAccountsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BatchAccountInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Page<BatchAccountInner>>(){

            public Page<BatchAccountInner> call(ServiceResponse<Page<BatchAccountInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(ServiceResponse<Page<BatchAccountInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BatchAccountsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BatchAccountsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BatchAccountInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<BatchAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BatchAccountInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<BatchAccountInner>((Page)response.getBody()){

            public Page<BatchAccountInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BatchAccountsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<BatchAccountInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<BatchAccountInner> serviceCallback) {
        return AzureServiceCall.create(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(String nextPageLink) {
                return BatchAccountsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BatchAccountInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Page<BatchAccountInner>>(){

            public Page<BatchAccountInner> call(ServiceResponse<Page<BatchAccountInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(ServiceResponse<Page<BatchAccountInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BatchAccountsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BatchAccountsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BatchAccountInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<BatchAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void synchronizeAutoStorageKeys(String resourceGroupName, String accountName) {
        ((ServiceResponse)this.synchronizeAutoStorageKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).getBody();
    }

    public ServiceCall<Void> synchronizeAutoStorageKeysAsync(String resourceGroupName, String accountName, ServiceCallback<Void> serviceCallback) {
        return ServiceCall.create(this.synchronizeAutoStorageKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<Void> synchronizeAutoStorageKeysAsync(String resourceGroupName, String accountName) {
        return this.synchronizeAutoStorageKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Void>> synchronizeAutoStorageKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.synchronizeAutoStorageKeys(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.synchronizeAutoStorageKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> synchronizeAutoStorageKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(204, new TypeToken<Void>(){}.getType()).build(response);
    }

    public BatchAccountKeysInner regenerateKey(String resourceGroupName, String accountName, AccountKeyType keyName) {
        return (BatchAccountKeysInner)((ServiceResponse)this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName).toBlocking().single()).getBody();
    }

    public ServiceCall<BatchAccountKeysInner> regenerateKeyAsync(String resourceGroupName, String accountName, AccountKeyType keyName, ServiceCallback<BatchAccountKeysInner> serviceCallback) {
        return ServiceCall.create(this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName), serviceCallback);
    }

    public Observable<BatchAccountKeysInner> regenerateKeyAsync(String resourceGroupName, String accountName, AccountKeyType keyName) {
        return this.regenerateKeyWithServiceResponseAsync(resourceGroupName, accountName, keyName).map((Func1)new Func1<ServiceResponse<BatchAccountKeysInner>, BatchAccountKeysInner>(){

            public BatchAccountKeysInner call(ServiceResponse<BatchAccountKeysInner> response) {
                return (BatchAccountKeysInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<BatchAccountKeysInner>> regenerateKeyWithServiceResponseAsync(String resourceGroupName, String accountName, AccountKeyType keyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        BatchAccountRegenerateKeyParameters parameters = new BatchAccountRegenerateKeyParameters();
        parameters.withKeyName(keyName);
        return this.service.regenerateKey(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchAccountKeysInner>>>(){

            public Observable<ServiceResponse<BatchAccountKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.regenerateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchAccountKeysInner> regenerateKeyDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<BatchAccountKeysInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BatchAccountKeysInner getKeys(String resourceGroupName, String accountName) {
        return (BatchAccountKeysInner)((ServiceResponse)this.getKeysWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).getBody();
    }

    public ServiceCall<BatchAccountKeysInner> getKeysAsync(String resourceGroupName, String accountName, ServiceCallback<BatchAccountKeysInner> serviceCallback) {
        return ServiceCall.create(this.getKeysWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<BatchAccountKeysInner> getKeysAsync(String resourceGroupName, String accountName) {
        return this.getKeysWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<BatchAccountKeysInner>, BatchAccountKeysInner>(){

            public BatchAccountKeysInner call(ServiceResponse<BatchAccountKeysInner> response) {
                return (BatchAccountKeysInner)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<BatchAccountKeysInner>> getKeysWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getKeys(resourceGroupName, accountName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchAccountKeysInner>>>(){

            public Observable<ServiceResponse<BatchAccountKeysInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BatchAccountsInner.this.getKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchAccountKeysInner> getKeysDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<BatchAccountKeysInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BatchAccountInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BatchAccountInner>((Page)response.getBody()){

            public Page<BatchAccountInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BatchAccountsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<BatchAccountInner>> listNextAsync(String nextPageLink, ServiceCall<List<BatchAccountInner>> serviceCall, ListOperationCallback<BatchAccountInner> serviceCallback) {
        return AzureServiceCall.create(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(String nextPageLink) {
                return BatchAccountsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BatchAccountInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Page<BatchAccountInner>>(){

            public Page<BatchAccountInner> call(ServiceResponse<Page<BatchAccountInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(ServiceResponse<Page<BatchAccountInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BatchAccountsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BatchAccountsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BatchAccountInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<BatchAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BatchAccountInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BatchAccountInner>((Page)response.getBody()){

            public Page<BatchAccountInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BatchAccountsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<BatchAccountInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceCall<List<BatchAccountInner>> serviceCall, ListOperationCallback<BatchAccountInner> serviceCallback) {
        return AzureServiceCall.create(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(String nextPageLink) {
                return BatchAccountsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BatchAccountInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Page<BatchAccountInner>>(){

            public Page<BatchAccountInner> call(ServiceResponse<Page<BatchAccountInner>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BatchAccountInner>>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(ServiceResponse<Page<BatchAccountInner>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BatchAccountsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BatchAccountInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.listByResourceGroupNext(nextPageLink, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BatchAccountInner>>>>(){

            public Observable<ServiceResponse<Page<BatchAccountInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BatchAccountsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<BatchAccountInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.client.mapperAdapter()).register(200, new TypeToken<PageImpl<BatchAccountInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BatchAccountsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body BatchAccountCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body BatchAccountCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Body BatchAccountUpdateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Batch/batchAccounts")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/syncAutoStorageKeys")
        public Observable<Response<ResponseBody>> synchronizeAutoStorageKeys(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/regenerateKeys")
        public Observable<Response<ResponseBody>> regenerateKey(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body BatchAccountRegenerateKeyParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/listKeys")
        public Observable<Response<ResponseBody>> getKeys(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="{nextLink}")
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Path(value="nextLink", encoded=true) String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

