/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.management.batch.implementation.ApplicationPackagesInner;
import com.microsoft.azure.management.batch.implementation.ApplicationsInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountsInner;
import com.microsoft.azure.management.batch.implementation.LocationsInner;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public final class BatchManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private BatchAccountsInner batchAccounts;
    private ApplicationPackagesInner applicationPackages;
    private ApplicationsInner applications;
    private LocationsInner locations;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public BatchManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public BatchManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public BatchManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public BatchManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public BatchAccountsInner batchAccounts() {
        return this.batchAccounts;
    }

    public ApplicationPackagesInner applicationPackages() {
        return this.applicationPackages;
    }

    public ApplicationsInner applications() {
        return this.applications;
    }

    public LocationsInner locations() {
        return this.locations;
    }

    public BatchManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public BatchManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        this(new RestClient.Builder().withBaseUrl(baseUrl).withCredentials(credentials).build());
    }

    public BatchManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2015-12-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.batchAccounts = new BatchAccountsInner(this.restClient().retrofit(), this);
        this.applicationPackages = new ApplicationPackagesInner(this.restClient().retrofit(), this);
        this.applications = new ApplicationsInner(this.restClient().retrofit(), this);
        this.locations = new LocationsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("Azure-SDK-For-Java/%s (%s)", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), "BatchManagementClient, 2015-12-01");
    }
}

