/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.RestClient;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.batch.BatchAccounts;
import com.microsoft.azure.management.batch.implementation.BatchAccountsImpl;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class BatchManager
extends Manager<BatchManager, BatchManagementClientImpl> {
    private BatchAccounts batchAccounts;
    private StorageManager storageManager;

    protected BatchManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new BatchManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
        this.storageManager = StorageManager.authenticate((RestClient)restClient, (String)subscriptionId);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static BatchManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new BatchManager(credentials.getEnvironment().newRestClientBuilder().withCredentials((ServiceClientCredentials)credentials).build(), subscriptionId);
    }

    public static BatchManager authenticate(RestClient restClient, String subscriptionId) {
        return new BatchManager(restClient, subscriptionId);
    }

    public BatchAccounts batchAccounts() {
        if (this.batchAccounts == null) {
            this.batchAccounts = new BatchAccountsImpl(((BatchManagementClientImpl)((Object)this.innerManagementClient)).batchAccounts(), this, ((BatchManagementClientImpl)((Object)this.innerManagementClient)).applications(), ((BatchManagementClientImpl)((Object)this.innerManagementClient)).applicationPackages(), ((BatchManagementClientImpl)((Object)this.innerManagementClient)).locations(), this.storageManager);
        }
        return this.batchAccounts;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public BatchManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return BatchManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public BatchManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

