/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A reference to an Azure Virtual Machines Marketplace image or the Azure
 * Image resource of a custom Virtual Machine. To get the list of all
 * imageReferences verified by Azure Batch, see the 'List supported node agent
 * SKUs' operation.
 */
public class ImageReference {
    /**
     * The publisher of the Azure Virtual Machines Marketplace image.
     * For example, Canonical or MicrosoftWindowsServer.
     */
    @JsonProperty(value = "publisher")
    private String publisher;

    /**
     * The offer type of the Azure Virtual Machines Marketplace image.
     * For example, UbuntuServer or WindowsServer.
     */
    @JsonProperty(value = "offer")
    private String offer;

    /**
     * The SKU of the Azure Virtual Machines Marketplace image.
     * For example, 14.04.0-LTS or 2012-R2-Datacenter.
     */
    @JsonProperty(value = "sku")
    private String sku;

    /**
     * The version of the Azure Virtual Machines Marketplace image.
     * A value of 'latest' can be specified to select the latest version of an
     * image. If omitted, the default is 'latest'.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * The ARM resource identifier of the virtual machine image. Computes nodes
     * of the pool will be created using this custom image. This is of the form
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}.
     * This property is mutually exclusive with other properties. The virtual
     * machine image must be in the same region and subscription as the Azure
     * Batch account. For information about the firewall settings for Batch
     * node agent to communicate with Batch service see
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     * .
     */
    @JsonProperty(value = "id")
    private String id;

    /**
     * Get the publisher value.
     *
     * @return the publisher value
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the publisher value.
     *
     * @param publisher the publisher value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the offer value.
     *
     * @return the offer value
     */
    public String offer() {
        return this.offer;
    }

    /**
     * Set the offer value.
     *
     * @param offer the offer value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withOffer(String offer) {
        this.offer = offer;
        return this;
    }

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the version value.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version value.
     *
     * @param version the version value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withId(String id) {
        this.id = id;
        return this;
    }

}
