/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batch.BatchAccount;
import com.microsoft.azure.management.batch.Pool;
import com.microsoft.azure.management.batch.implementation.BatchAccountImpl;
import com.microsoft.azure.management.batch.implementation.BatchAccountInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.BatchManager;
import com.microsoft.azure.management.batch.implementation.PoolImpl;
import com.microsoft.azure.management.batch.implementation.PoolInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LangDefinition
public class PoolsImpl
extends ExternalChildResourcesCachedImpl<PoolImpl, Pool, PoolInner, BatchAccountImpl, BatchAccount> {
    PoolsImpl(BatchAccountImpl parent) {
        super((Object)parent, parent.taskGroup(), "Pool");
        this.cacheCollection();
    }

    public PoolImpl define(String name) {
        return (PoolImpl)this.prepareInlineDefine(name);
    }

    public PoolImpl update(String name) {
        return (PoolImpl)this.prepareInlineUpdate(name);
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    protected List<PoolImpl> listChildResources() {
        ArrayList<PoolImpl> childResources = new ArrayList<PoolImpl>();
        if (((BatchAccountInner)((Object)((BatchAccountImpl)this.parent()).inner())).id() == null || ((BatchAccountImpl)this.parent()).autoStorage() == null) {
            return childResources;
        }
        PagedList<PoolInner> poolList = ((BatchManagementClientImpl)((Object)((BatchManager)((BatchAccountImpl)this.parent()).manager()).inner())).pools().listByBatchAccount(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name());
        for (PoolInner pool : poolList) {
            childResources.add(new PoolImpl(pool.name(), (BatchAccountImpl)this.parent(), pool));
        }
        return childResources;
    }

    protected PoolImpl newChildResource(String name) {
        PoolImpl pool = PoolImpl.newPool(name, (BatchAccountImpl)this.parent());
        return pool;
    }

    public void addPool(PoolImpl pool) {
        this.addChildResource(pool);
    }

    public Map<String, Pool> asMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            PoolImpl pool = (PoolImpl)entry.getValue();
            result.put(entry.getKey(), pool);
        }
        return Collections.unmodifiableMap(result);
    }
}

