/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Parameters supplied to the Create operation.
 */
@JsonFlatten
public class BatchAccountCreateParameters {
    /**
     * The region in which to create the account.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The user-specified tags associated with the account.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * The properties related to the auto-storage account.
     */
    @JsonProperty(value = "properties.autoStorage")
    private AutoStorageBaseProperties autoStorage;

    /**
     * The allocation mode to use for creating pools in the Batch account.
     * The pool allocation mode also affects how clients may authenticate to
     * the Batch Service API. If the mode is BatchService, clients may
     * authenticate using access keys or Azure Active Directory. If the mode is
     * UserSubscription, clients must use Azure Active Directory. The default
     * is BatchService. Possible values include: 'BatchService',
     * 'UserSubscription'.
     */
    @JsonProperty(value = "properties.poolAllocationMode")
    private PoolAllocationMode poolAllocationMode;

    /**
     * A reference to the Azure key vault associated with the Batch account.
     */
    @JsonProperty(value = "properties.keyVaultReference")
    private KeyVaultReference keyVaultReference;

    /**
     * Get the region in which to create the account.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the region in which to create the account.
     *
     * @param location the location value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the user-specified tags associated with the account.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the user-specified tags associated with the account.
     *
     * @param tags the tags value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties related to the auto-storage account.
     *
     * @return the autoStorage value
     */
    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    /**
     * Set the properties related to the auto-storage account.
     *
     * @param autoStorage the autoStorage value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    /**
     * Get the pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService. Possible values include: 'BatchService', 'UserSubscription'.
     *
     * @return the poolAllocationMode value
     */
    public PoolAllocationMode poolAllocationMode() {
        return this.poolAllocationMode;
    }

    /**
     * Set the pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService. Possible values include: 'BatchService', 'UserSubscription'.
     *
     * @param poolAllocationMode the poolAllocationMode value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withPoolAllocationMode(PoolAllocationMode poolAllocationMode) {
        this.poolAllocationMode = poolAllocationMode;
        return this;
    }

    /**
     * Get a reference to the Azure key vault associated with the Batch account.
     *
     * @return the keyVaultReference value
     */
    public KeyVaultReference keyVaultReference() {
        return this.keyVaultReference;
    }

    /**
     * Set a reference to the Azure key vault associated with the Batch account.
     *
     * @param keyVaultReference the keyVaultReference value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withKeyVaultReference(KeyVaultReference keyVaultReference) {
        this.keyVaultReference = keyVaultReference;
        return this;
    }

}
