/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Scale settings for the pool.
 * Defines the desired size of the pool. This can either be 'fixedScale' where
 * the requested targetDedicatedNodes is specified, or 'autoScale' which
 * defines a formula which is periodically reevaluated. If this property is not
 * specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
 */
public class ScaleSettings {
    /**
     * Fixed scale settings for the pool.
     * This property and autoScale are mutually exclusive and one of the
     * properties must be specified.
     */
    @JsonProperty(value = "fixedScale")
    private FixedScaleSettings fixedScale;

    /**
     * AutoScale settings for the pool.
     * This property and fixedScale are mutually exclusive and one of the
     * properties must be specified.
     */
    @JsonProperty(value = "autoScale")
    private AutoScaleSettings autoScale;

    /**
     * Get this property and autoScale are mutually exclusive and one of the properties must be specified.
     *
     * @return the fixedScale value
     */
    public FixedScaleSettings fixedScale() {
        return this.fixedScale;
    }

    /**
     * Set this property and autoScale are mutually exclusive and one of the properties must be specified.
     *
     * @param fixedScale the fixedScale value to set
     * @return the ScaleSettings object itself.
     */
    public ScaleSettings withFixedScale(FixedScaleSettings fixedScale) {
        this.fixedScale = fixedScale;
        return this;
    }

    /**
     * Get this property and fixedScale are mutually exclusive and one of the properties must be specified.
     *
     * @return the autoScale value
     */
    public AutoScaleSettings autoScale() {
        return this.autoScale;
    }

    /**
     * Set this property and fixedScale are mutually exclusive and one of the properties must be specified.
     *
     * @param autoScale the autoScale value to set
     * @return the ScaleSettings object itself.
     */
    public ScaleSettings withAutoScale(AutoScaleSettings autoScale) {
        this.autoScale = autoScale;
        return this;
    }

}
