/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Parameters for updating an Azure Batch account.
 */
@JsonFlatten
public class BatchAccountUpdateParameters {
    /**
     * The user-specified tags associated with the account.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * The properties related to the auto-storage account.
     */
    @JsonProperty(value = "properties.autoStorage")
    private AutoStorageBaseProperties autoStorage;

    /**
     * The encryption configuration for the Batch account.
     * Configures how customer data is encrypted inside the Batch account. By
     * default, accounts are encrypted using a Microsoft managed key. For
     * additional control, a customer-managed key can be used instead.
     */
    @JsonProperty(value = "properties.encryption")
    private EncryptionProperties encryption;

    /**
     * The identity of the Batch account.
     */
    @JsonProperty(value = "identity")
    private BatchAccountIdentity identity;

    /**
     * Get the user-specified tags associated with the account.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the user-specified tags associated with the account.
     *
     * @param tags the tags value to set
     * @return the BatchAccountUpdateParameters object itself.
     */
    public BatchAccountUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties related to the auto-storage account.
     *
     * @return the autoStorage value
     */
    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    /**
     * Set the properties related to the auto-storage account.
     *
     * @param autoStorage the autoStorage value to set
     * @return the BatchAccountUpdateParameters object itself.
     */
    public BatchAccountUpdateParameters withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    /**
     * Get configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     *
     * @return the encryption value
     */
    public EncryptionProperties encryption() {
        return this.encryption;
    }

    /**
     * Set configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     *
     * @param encryption the encryption value to set
     * @return the BatchAccountUpdateParameters object itself.
     */
    public BatchAccountUpdateParameters withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get the identity of the Batch account.
     *
     * @return the identity value
     */
    public BatchAccountIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity of the Batch account.
     *
     * @param identity the identity value to set
     * @return the BatchAccountUpdateParameters object itself.
     */
    public BatchAccountUpdateParameters withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

}
