/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.Map;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The identity of the Batch pool, if configured. If the pool identity is
 * updated during update an existing pool, only the new vms which are created
 * after the pool shrinks to 0 will have the updated identities.
 */
public class BatchPoolIdentity {
    /**
     * The type of identity used for the Batch Pool. Possible values include:
     * 'UserAssigned', 'None'.
     */
    @JsonProperty(value = "type", required = true)
    private PoolIdentityType type;

    /**
     * The list of user identities associated with the Batch pool. The user
     * identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JsonProperty(value = "userAssignedIdentities")
    private Map<String, BatchPoolIdentityUserAssignedIdentitiesValue> userAssignedIdentities;

    /**
     * Get the type of identity used for the Batch Pool. Possible values include: 'UserAssigned', 'None'.
     *
     * @return the type value
     */
    public PoolIdentityType type() {
        return this.type;
    }

    /**
     * Set the type of identity used for the Batch Pool. Possible values include: 'UserAssigned', 'None'.
     *
     * @param type the type value to set
     * @return the BatchPoolIdentity object itself.
     */
    public BatchPoolIdentity withType(PoolIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the list of user identities associated with the Batch pool. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     *
     * @return the userAssignedIdentities value
     */
    public Map<String, BatchPoolIdentityUserAssignedIdentitiesValue> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the list of user identities associated with the Batch pool. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     *
     * @param userAssignedIdentities the userAssignedIdentities value to set
     * @return the BatchPoolIdentity object itself.
     */
    public BatchPoolIdentity withUserAssignedIdentities(Map<String, BatchPoolIdentityUserAssignedIdentitiesValue> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

}
