/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The disk encryption configuration applied on compute nodes in the pool. Disk
 * encryption configuration is not supported on Linux pool created with Virtual
 * Machine Image or Shared Image Gallery Image.
 */
public class DiskEncryptionConfiguration {
    /**
     * The list of disk targets Batch Service will encrypt on the compute node.
     * On Linux pool, only "TemporaryDisk" is supported; on Windows pool,
     * "OsDisk" and "TemporaryDisk" must be specified.
     */
    @JsonProperty(value = "targets")
    private List<DiskEncryptionTarget> targets;

    /**
     * Get on Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
     *
     * @return the targets value
     */
    public List<DiskEncryptionTarget> targets() {
        return this.targets;
    }

    /**
     * Set on Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
     *
     * @param targets the targets value to set
     * @return the DiskEncryptionConfiguration object itself.
     */
    public DiskEncryptionConfiguration withTargets(List<DiskEncryptionTarget> targets) {
        this.targets = targets;
        return this;
    }

}
