/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A domain name and connection details used to access a dependency.
 */
public class EndpointDependency {
    /**
     * The domain name of the dependency. Domain names may be fully qualified
     * or may contain a * wildcard.
     */
    @JsonProperty(value = "domainName", access = JsonProperty.Access.WRITE_ONLY)
    private String domainName;

    /**
     * Human-readable supplemental information about the dependency and when it
     * is applicable.
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /**
     * The list of connection details for this endpoint.
     */
    @JsonProperty(value = "endpointDetails", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointDetail> endpointDetails;

    /**
     * Get the domain name of the dependency. Domain names may be fully qualified or may contain a * wildcard.
     *
     * @return the domainName value
     */
    public String domainName() {
        return this.domainName;
    }

    /**
     * Get human-readable supplemental information about the dependency and when it is applicable.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the list of connection details for this endpoint.
     *
     * @return the endpointDetails value
     */
    public List<EndpointDetail> endpointDetails() {
        return this.endpointDetails;
    }

}
