/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.management.batch.ProvisioningState;
import com.microsoft.azure.management.batch.PoolAllocationMode;
import com.microsoft.azure.management.batch.KeyVaultReference;
import com.microsoft.azure.management.batch.PublicNetworkAccessType;
import java.util.List;
import com.microsoft.azure.management.batch.AutoStorageProperties;
import com.microsoft.azure.management.batch.EncryptionProperties;
import com.microsoft.azure.management.batch.VirtualMachineFamilyCoreQuota;
import com.microsoft.azure.management.batch.AuthenticationMode;
import com.microsoft.azure.management.batch.BatchAccountIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.rest.SkipParentValidation;
import com.microsoft.azure.Resource;

/**
 * Contains information about an Azure Batch account.
 */
@JsonFlatten
@SkipParentValidation
public class BatchAccountInner extends Resource {
    /**
     * The account endpoint used to interact with the Batch service.
     */
    @JsonProperty(value = "properties.accountEndpoint", access = JsonProperty.Access.WRITE_ONLY)
    private String accountEndpoint;

    /**
     * The provisioned state of the resource. Possible values include:
     * 'Invalid', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Cancelled'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * The allocation mode to use for creating pools in the Batch account.
     * Possible values include: 'BatchService', 'UserSubscription'.
     */
    @JsonProperty(value = "properties.poolAllocationMode", access = JsonProperty.Access.WRITE_ONLY)
    private PoolAllocationMode poolAllocationMode;

    /**
     * A reference to the Azure key vault associated with the Batch account.
     */
    @JsonProperty(value = "properties.keyVaultReference", access = JsonProperty.Access.WRITE_ONLY)
    private KeyVaultReference keyVaultReference;

    /**
     * The network interface type for accessing Azure Batch service and Batch
     * account operations.
     * If not specified, the default value is 'enabled'. Possible values
     * include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.publicNetworkAccess", access = JsonProperty.Access.WRITE_ONLY)
    private PublicNetworkAccessType publicNetworkAccess;

    /**
     * List of private endpoint connections associated with the Batch account.
     */
    @JsonProperty(value = "properties.privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;

    /**
     * The properties and status of any auto-storage account associated with
     * the Batch account.
     */
    @JsonProperty(value = "properties.autoStorage", access = JsonProperty.Access.WRITE_ONLY)
    private AutoStorageProperties autoStorage;

    /**
     * The encryption configuration for the Batch account.
     * Configures how customer data is encrypted inside the Batch account. By
     * default, accounts are encrypted using a Microsoft managed key. For
     * additional control, a customer-managed key can be used instead.
     */
    @JsonProperty(value = "properties.encryption", access = JsonProperty.Access.WRITE_ONLY)
    private EncryptionProperties encryption;

    /**
     * The dedicated core quota for the Batch account.
     * For accounts with PoolAllocationMode set to UserSubscription, quota is
     * managed on the subscription so this value is not returned.
     */
    @JsonProperty(value = "properties.dedicatedCoreQuota", access = JsonProperty.Access.WRITE_ONLY)
    private Integer dedicatedCoreQuota;

    /**
     * The low-priority core quota for the Batch account.
     * For accounts with PoolAllocationMode set to UserSubscription, quota is
     * managed on the subscription so this value is not returned.
     */
    @JsonProperty(value = "properties.lowPriorityCoreQuota", access = JsonProperty.Access.WRITE_ONLY)
    private Integer lowPriorityCoreQuota;

    /**
     * A list of the dedicated core quota per Virtual Machine family for the
     * Batch account. For accounts with PoolAllocationMode set to
     * UserSubscription, quota is managed on the subscription so this value is
     * not returned.
     */
    @JsonProperty(value = "properties.dedicatedCoreQuotaPerVMFamily", access = JsonProperty.Access.WRITE_ONLY)
    private List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily;

    /**
     * A value indicating whether core quotas per Virtual Machine family are
     * enforced for this account.
     * Batch is transitioning its core quota system for dedicated cores to be
     * enforced per Virtual Machine family. During this transitional phase, the
     * dedicated core quota per Virtual Machine family may not yet be enforced.
     * If this flag is false, dedicated core quota is enforced via the old
     * dedicatedCoreQuota property on the account and does not consider Virtual
     * Machine family. If this flag is true, dedicated core quota is enforced
     * via the dedicatedCoreQuotaPerVMFamily property on the account, and the
     * old dedicatedCoreQuota does not apply.
     */
    @JsonProperty(value = "properties.dedicatedCoreQuotaPerVMFamilyEnforced", access = JsonProperty.Access.WRITE_ONLY)
    private boolean dedicatedCoreQuotaPerVMFamilyEnforced;

    /**
     * The pool quota for the Batch account.
     */
    @JsonProperty(value = "properties.poolQuota", access = JsonProperty.Access.WRITE_ONLY)
    private int poolQuota;

    /**
     * The active job and job schedule quota for the Batch account.
     */
    @JsonProperty(value = "properties.activeJobAndJobScheduleQuota", access = JsonProperty.Access.WRITE_ONLY)
    private int activeJobAndJobScheduleQuota;

    /**
     * List of allowed authentication modes for the Batch account that can be
     * used to authenticate with the data plane. This does not affect
     * authentication with the control plane.
     */
    @JsonProperty(value = "properties.allowedAuthenticationModes", access = JsonProperty.Access.WRITE_ONLY)
    private List<AuthenticationMode> allowedAuthenticationModes;

    /**
     * The identity of the Batch account.
     */
    @JsonProperty(value = "identity")
    private BatchAccountIdentity identity;

    /**
     * Get the account endpoint used to interact with the Batch service.
     *
     * @return the accountEndpoint value
     */
    public String accountEndpoint() {
        return this.accountEndpoint;
    }

    /**
     * Get the provisioned state of the resource. Possible values include: 'Invalid', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Cancelled'.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get possible values include: 'BatchService', 'UserSubscription'.
     *
     * @return the poolAllocationMode value
     */
    public PoolAllocationMode poolAllocationMode() {
        return this.poolAllocationMode;
    }

    /**
     * Get the keyVaultReference value.
     *
     * @return the keyVaultReference value
     */
    public KeyVaultReference keyVaultReference() {
        return this.keyVaultReference;
    }

    /**
     * Get if not specified, the default value is 'enabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the publicNetworkAccess value
     */
    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Get list of private endpoint connections associated with the Batch account.
     *
     * @return the privateEndpointConnections value
     */
    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the autoStorage value.
     *
     * @return the autoStorage value
     */
    public AutoStorageProperties autoStorage() {
        return this.autoStorage;
    }

    /**
     * Get configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     *
     * @return the encryption value
     */
    public EncryptionProperties encryption() {
        return this.encryption;
    }

    /**
     * Get for accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
     *
     * @return the dedicatedCoreQuota value
     */
    public Integer dedicatedCoreQuota() {
        return this.dedicatedCoreQuota;
    }

    /**
     * Get for accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
     *
     * @return the lowPriorityCoreQuota value
     */
    public Integer lowPriorityCoreQuota() {
        return this.lowPriorityCoreQuota;
    }

    /**
     * Get a list of the dedicated core quota per Virtual Machine family for the Batch account. For accounts with PoolAllocationMode set to UserSubscription, quota is managed on the subscription so this value is not returned.
     *
     * @return the dedicatedCoreQuotaPerVMFamily value
     */
    public List<VirtualMachineFamilyCoreQuota> dedicatedCoreQuotaPerVMFamily() {
        return this.dedicatedCoreQuotaPerVMFamily;
    }

    /**
     * Get batch is transitioning its core quota system for dedicated cores to be enforced per Virtual Machine family. During this transitional phase, the dedicated core quota per Virtual Machine family may not yet be enforced. If this flag is false, dedicated core quota is enforced via the old dedicatedCoreQuota property on the account and does not consider Virtual Machine family. If this flag is true, dedicated core quota is enforced via the dedicatedCoreQuotaPerVMFamily property on the account, and the old dedicatedCoreQuota does not apply.
     *
     * @return the dedicatedCoreQuotaPerVMFamilyEnforced value
     */
    public boolean dedicatedCoreQuotaPerVMFamilyEnforced() {
        return this.dedicatedCoreQuotaPerVMFamilyEnforced;
    }

    /**
     * Get the poolQuota value.
     *
     * @return the poolQuota value
     */
    public int poolQuota() {
        return this.poolQuota;
    }

    /**
     * Get the activeJobAndJobScheduleQuota value.
     *
     * @return the activeJobAndJobScheduleQuota value
     */
    public int activeJobAndJobScheduleQuota() {
        return this.activeJobAndJobScheduleQuota;
    }

    /**
     * Get list of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     *
     * @return the allowedAuthenticationModes value
     */
    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    /**
     * Get the identity of the Batch account.
     *
     * @return the identity value
     */
    public BatchAccountIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity of the Batch account.
     *
     * @param identity the identity value to set
     * @return the BatchAccountInner object itself.
     */
    public BatchAccountInner withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

}
