/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.batch.PoolCreateHeaders;
import com.microsoft.azure.management.batch.PoolDeleteHeaders;
import com.microsoft.azure.management.batch.PoolDisableAutoScaleHeaders;
import com.microsoft.azure.management.batch.PoolGetHeaders;
import com.microsoft.azure.management.batch.PoolStopResizeHeaders;
import com.microsoft.azure.management.batch.PoolUpdateHeaders;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Pools.
 */
public class PoolsInner {
    /** The Retrofit service to perform REST calls. */
    private PoolsService service;
    /** The service client containing this operation class. */
    private BatchManagementClientImpl client;

    /**
     * Initializes an instance of PoolsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PoolsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = retrofit.create(PoolsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Pools to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PoolsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools listByBatchAccount" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools")
        Observable<Response<ResponseBody>> listByBatchAccount(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Query("maxresults") Integer maxresults, @Query("$select") String select, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Body PoolInner parameters, @Header("If-Match") String ifMatch, @Header("If-None-Match") String ifNoneMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Body PoolInner parameters, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools disableAutoScale" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}/disableAutoScale")
        Observable<Response<ResponseBody>> disableAutoScale(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools stopResize" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/pools/{poolName}/stopResize")
        Observable<Response<ResponseBody>> stopResize(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("poolName") String poolName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Pools listByBatchAccountNext" })
        @GET
        Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PoolInner&gt; object if successful.
     */
    public PagedList<PoolInner> listByBatchAccount(final String resourceGroupName, final String accountName) {
        ServiceResponse<Page<PoolInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<PoolInner>(response.body()) {
            @Override
            public Page<PoolInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PoolInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final ListOperationCallback<PoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName),
            new Func1<String, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PoolInner&gt; object
     */
    public Observable<Page<PoolInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName)
            .map(new Func1<ServiceResponse<Page<PoolInner>>, Page<PoolInner>>() {
                @Override
                public Page<PoolInner> call(ServiceResponse<Page<PoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName)
            .concatMap(new Func1<ServiceResponse<Page<PoolInner>>, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(ServiceResponse<Page<PoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer maxresults = null;
        final String select = null;
        final String filter = null;
        return service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PoolInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are:
      name
      properties/allocationState
      properties/allocationStateTransitionTime
      properties/creationTime
      properties/provisioningState
      properties/provisioningStateTransitionTime
      properties/lastModified
      properties/vmSize
      properties/interNodeCommunication
      properties/scaleSettings/autoScale
      properties/scaleSettings/fixedScale
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PoolInner&gt; object if successful.
     */
    public PagedList<PoolInner> listByBatchAccount(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        ServiceResponse<Page<PoolInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter).toBlocking().single();
        return new PagedList<PoolInner>(response.body()) {
            @Override
            public Page<PoolInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are:
      name
      properties/allocationState
      properties/allocationStateTransitionTime
      properties/creationTime
      properties/provisioningState
      properties/provisioningStateTransitionTime
      properties/lastModified
      properties/vmSize
      properties/interNodeCommunication
      properties/scaleSettings/autoScale
      properties/scaleSettings/fixedScale
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PoolInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter, final ListOperationCallback<PoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter),
            new Func1<String, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are:
      name
      properties/allocationState
      properties/allocationStateTransitionTime
      properties/creationTime
      properties/provisioningState
      properties/provisioningStateTransitionTime
      properties/lastModified
      properties/vmSize
      properties/interNodeCommunication
      properties/scaleSettings/autoScale
      properties/scaleSettings/fixedScale
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PoolInner&gt; object
     */
    public Observable<Page<PoolInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults, select, filter)
            .map(new Func1<ServiceResponse<Page<PoolInner>>, Page<PoolInner>>() {
                @Override
                public Page<PoolInner> call(ServiceResponse<Page<PoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are:
      name
      properties/allocationState
      properties/allocationStateTransitionTime
      properties/creationTime
      properties/provisioningState
      properties/provisioningStateTransitionTime
      properties/lastModified
      properties/vmSize
      properties/interNodeCommunication
      properties/scaleSettings/autoScale
      properties/scaleSettings/fixedScale
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter)
            .concatMap(new Func1<ServiceResponse<Page<PoolInner>>, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(ServiceResponse<Page<PoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
    ServiceResponse<PageImpl<PoolInner>> * @param resourceGroupName The name of the resource group that contains the Batch account.
    ServiceResponse<PageImpl<PoolInner>> * @param accountName The name of the Batch account.
    ServiceResponse<PageImpl<PoolInner>> * @param maxresults The maximum number of items to return in the response.
    ServiceResponse<PageImpl<PoolInner>> * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
    ServiceResponse<PageImpl<PoolInner>> * @param filter OData filter expression. Valid properties for filtering are:
      name
      properties/allocationState
      properties/allocationStateTransitionTime
      properties/creationTime
      properties/provisioningState
      properties/provisioningStateTransitionTime
      properties/lastModified
      properties/vmSize
      properties/interNodeCommunication
      properties/scaleSettings/autoScale
      properties/scaleSettings/fixedScale
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PoolInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PoolInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner create(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters), serviceCallback);
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return service.create(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @param ifMatch The entity state (ETag) version of the pool to update. A value of "*" can be used to apply the operation only if the pool already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new pool to be created, but to prevent updating an existing pool. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner create(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch).toBlocking().single().body();
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @param ifMatch The entity state (ETag) version of the pool to update. A value of "*" can be used to apply the operation only if the pool already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new pool to be created, but to prevent updating an existing pool. Other values will be ignored.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @param ifMatch The entity state (ETag) version of the pool to update. A value of "*" can be used to apply the operation only if the pool already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new pool to be created, but to prevent updating an existing pool. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> createAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch, ifNoneMatch).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new pool inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Additional parameters for pool creation.
     * @param ifMatch The entity state (ETag) version of the pool to update. A value of "*" can be used to apply the operation only if the pool already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new pool to be created, but to prevent updating an existing pool. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolCreateHeaders> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PoolInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PoolCreateHeaders.class);
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner update(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).toBlocking().single().body();
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters), serviceCallback);
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        return service.update(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner update(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch).toBlocking().single().body();
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch), serviceCallback);
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> updateAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, poolName, parameters, ifMatch).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param parameters Pool properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The entity state (ETag) version of the pool to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName, PoolInner parameters, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(resourceGroupName, accountName, poolName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PoolInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PoolUpdateHeaders.class);
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String accountName, String poolName) {
        deleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().last().body();
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String poolName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(deleteWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String poolName) {
        return deleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).map(new Func1<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>, Void>() {
            @Override
            public Void call(ServiceResponseWithHeaders<Void, PoolDeleteHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new TypeToken<Void>() { }.getType(), PoolDeleteHeaders.class);
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String accountName, String poolName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single().body();
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponseWithHeaders} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName, String poolName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, poolName).map(new Func1<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>, Void>() {
            @Override
            public Void call(ServiceResponseWithHeaders<Void, PoolDeleteHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponseWithHeaders} object if successful.
     */
    public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<Void, PoolDeleteHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<Void, PoolDeleteHeaders> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<Void, PoolDeleteHeaders> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PoolDeleteHeaders.class);
    }

    /**
     * Gets information about the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner get(String resourceGroupName, String accountName, String poolName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single().body();
    }

    /**
     * Gets information about the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> getAsync(String resourceGroupName, String accountName, String poolName, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(getWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    /**
     * Gets information about the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> getAsync(String resourceGroupName, String accountName, String poolName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, poolName).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolGetHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about the specified pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolGetHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolGetHeaders> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolGetHeaders> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PoolInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PoolGetHeaders.class);
    }

    /**
     * Disables automatic scaling for a pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner disableAutoScale(String resourceGroupName, String accountName, String poolName) {
        return disableAutoScaleWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single().body();
    }

    /**
     * Disables automatic scaling for a pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> disableAutoScaleAsync(String resourceGroupName, String accountName, String poolName, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(disableAutoScaleWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    /**
     * Disables automatic scaling for a pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> disableAutoScaleAsync(String resourceGroupName, String accountName, String poolName) {
        return disableAutoScaleWithServiceResponseAsync(resourceGroupName, accountName, poolName).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Disables automatic scaling for a pool.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>> disableAutoScaleWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.disableAutoScale(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders> clientResponse = disableAutoScaleDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolDisableAutoScaleHeaders> disableAutoScaleDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PoolInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PoolDisableAutoScaleHeaders.class);
    }

    /**
     * Stops an ongoing resize operation on the pool.
     * This does not restore the pool to its previous state before the resize operation: it only stops any further changes being made, and the pool maintains its current state. After stopping, the pool stabilizes at the number of nodes it was at when the stop operation was done. During the stop operation, the pool allocation state changes first to stopping and then to steady. A resize operation need not be an explicit resize pool request; this API can also be used to halt the initial sizing of the pool when it is created.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PoolInner object if successful.
     */
    public PoolInner stopResize(String resourceGroupName, String accountName, String poolName) {
        return stopResizeWithServiceResponseAsync(resourceGroupName, accountName, poolName).toBlocking().single().body();
    }

    /**
     * Stops an ongoing resize operation on the pool.
     * This does not restore the pool to its previous state before the resize operation: it only stops any further changes being made, and the pool maintains its current state. After stopping, the pool stabilizes at the number of nodes it was at when the stop operation was done. During the stop operation, the pool allocation state changes first to stopping and then to steady. A resize operation need not be an explicit resize pool request; this API can also be used to halt the initial sizing of the pool when it is created.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PoolInner> stopResizeAsync(String resourceGroupName, String accountName, String poolName, final ServiceCallback<PoolInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(stopResizeWithServiceResponseAsync(resourceGroupName, accountName, poolName), serviceCallback);
    }

    /**
     * Stops an ongoing resize operation on the pool.
     * This does not restore the pool to its previous state before the resize operation: it only stops any further changes being made, and the pool maintains its current state. After stopping, the pool stabilizes at the number of nodes it was at when the stop operation was done. During the stop operation, the pool allocation state changes first to stopping and then to steady. A resize operation need not be an explicit resize pool request; this API can also be used to halt the initial sizing of the pool when it is created.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<PoolInner> stopResizeAsync(String resourceGroupName, String accountName, String poolName) {
        return stopResizeWithServiceResponseAsync(resourceGroupName, accountName, poolName).map(new Func1<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>, PoolInner>() {
            @Override
            public PoolInner call(ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Stops an ongoing resize operation on the pool.
     * This does not restore the pool to its previous state before the resize operation: it only stops any further changes being made, and the pool maintains its current state. After stopping, the pool stabilizes at the number of nodes it was at when the stop operation was done. During the stop operation, the pool allocation state changes first to stopping and then to steady. A resize operation need not be an explicit resize pool request; this API can also be used to halt the initial sizing of the pool when it is created.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param poolName The pool name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PoolInner object
     */
    public Observable<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>> stopResizeWithServiceResponseAsync(String resourceGroupName, String accountName, String poolName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (poolName == null) {
            throw new IllegalArgumentException("Parameter poolName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.stopResize(resourceGroupName, accountName, poolName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders> clientResponse = stopResizeDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<PoolInner, PoolStopResizeHeaders> stopResizeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PoolInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PoolInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PoolStopResizeHeaders.class);
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PoolInner&gt; object if successful.
     */
    public PagedList<PoolInner> listByBatchAccountNext(final String nextPageLink) {
        ServiceResponse<Page<PoolInner>> response = listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PoolInner>(response.body()) {
            @Override
            public Page<PoolInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PoolInner>> listByBatchAccountNextAsync(final String nextPageLink, final ServiceFuture<List<PoolInner>> serviceFuture, final ListOperationCallback<PoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PoolInner&gt; object
     */
    public Observable<Page<PoolInner>> listByBatchAccountNextAsync(final String nextPageLink) {
        return listByBatchAccountNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PoolInner>>, Page<PoolInner>>() {
                @Override
                public Page<PoolInner> call(ServiceResponse<Page<PoolInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PoolInner&gt; object
     */
    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountNextWithServiceResponseAsync(final String nextPageLink) {
        return listByBatchAccountNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PoolInner>>, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(ServiceResponse<Page<PoolInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the pools in the specified account.
     *
    ServiceResponse<PageImpl<PoolInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PoolInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PoolInner>>> listByBatchAccountNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PoolInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PoolInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PoolInner>> result = listByBatchAccountNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PoolInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PoolInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PoolInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PoolInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
