/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in PrivateLinkResources.
 */
public class PrivateLinkResourcesInner {
    /** The Retrofit service to perform REST calls. */
    private PrivateLinkResourcesService service;
    /** The service client containing this operation class. */
    private BatchManagementClientImpl client;

    /**
     * Initializes an instance of PrivateLinkResourcesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PrivateLinkResourcesInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = retrofit.create(PrivateLinkResourcesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for PrivateLinkResources to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PrivateLinkResourcesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateLinkResources listByBatchAccount" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateLinkResources")
        Observable<Response<ResponseBody>> listByBatchAccount(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Query("maxresults") Integer maxresults, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateLinkResources get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateLinkResources/{privateLinkResourceName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("privateLinkResourceName") String privateLinkResourceName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateLinkResources listByBatchAccountNext" })
        @GET
        Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkResourceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkResourceInner> listByBatchAccount(final String resourceGroupName, final String accountName) {
        ServiceResponse<Page<PrivateLinkResourceInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<PrivateLinkResourceInner>(response.body()) {
            @Override
            public Page<PrivateLinkResourceInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkResourceInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final ListOperationCallback<PrivateLinkResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkResourceInner&gt; object
     */
    public Observable<Page<PrivateLinkResourceInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName)
            .map(new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Page<PrivateLinkResourceInner>>() {
                @Override
                public Page<PrivateLinkResourceInner> call(ServiceResponse<Page<PrivateLinkResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName)
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(ServiceResponse<Page<PrivateLinkResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer maxresults = null;
        return service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkResourceInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkResourceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkResourceInner> listByBatchAccount(final String resourceGroupName, final String accountName, final Integer maxresults) {
        ServiceResponse<Page<PrivateLinkResourceInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults).toBlocking().single();
        return new PagedList<PrivateLinkResourceInner>(response.body()) {
            @Override
            public Page<PrivateLinkResourceInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkResourceInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final ListOperationCallback<PrivateLinkResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkResourceInner&gt; object
     */
    public Observable<Page<PrivateLinkResourceInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults)
            .map(new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Page<PrivateLinkResourceInner>>() {
                @Override
                public Page<PrivateLinkResourceInner> call(ServiceResponse<Page<PrivateLinkResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName, final Integer maxresults) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults)
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(ServiceResponse<Page<PrivateLinkResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
    ServiceResponse<PageImpl<PrivateLinkResourceInner>> * @param resourceGroupName The name of the resource group that contains the Batch account.
    ServiceResponse<PageImpl<PrivateLinkResourceInner>> * @param accountName The name of the Batch account.
    ServiceResponse<PageImpl<PrivateLinkResourceInner>> * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName, final Integer maxresults) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkResourceInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateLinkResourceInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateLinkResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateLinkResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the specified private link resource.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateLinkResourceName The private link resource name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateLinkResourceInner object if successful.
     */
    public PrivateLinkResourceInner get(String resourceGroupName, String accountName, String privateLinkResourceName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, privateLinkResourceName).toBlocking().single().body();
    }

    /**
     * Gets information about the specified private link resource.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateLinkResourceName The private link resource name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateLinkResourceInner> getAsync(String resourceGroupName, String accountName, String privateLinkResourceName, final ServiceCallback<PrivateLinkResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, accountName, privateLinkResourceName), serviceCallback);
    }

    /**
     * Gets information about the specified private link resource.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateLinkResourceName The private link resource name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkResourceInner object
     */
    public Observable<PrivateLinkResourceInner> getAsync(String resourceGroupName, String accountName, String privateLinkResourceName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, privateLinkResourceName).map(new Func1<ServiceResponse<PrivateLinkResourceInner>, PrivateLinkResourceInner>() {
            @Override
            public PrivateLinkResourceInner call(ServiceResponse<PrivateLinkResourceInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about the specified private link resource.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateLinkResourceName The private link resource name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateLinkResourceInner object
     */
    public Observable<ServiceResponse<PrivateLinkResourceInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String privateLinkResourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateLinkResourceName == null) {
            throw new IllegalArgumentException("Parameter privateLinkResourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(this.client.subscriptionId(), resourceGroupName, accountName, privateLinkResourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateLinkResourceInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateLinkResourceInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateLinkResourceInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateLinkResourceInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateLinkResourceInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateLinkResourceInner&gt; object if successful.
     */
    public PagedList<PrivateLinkResourceInner> listByBatchAccountNext(final String nextPageLink) {
        ServiceResponse<Page<PrivateLinkResourceInner>> response = listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateLinkResourceInner>(response.body()) {
            @Override
            public Page<PrivateLinkResourceInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateLinkResourceInner>> listByBatchAccountNextAsync(final String nextPageLink, final ServiceFuture<List<PrivateLinkResourceInner>> serviceFuture, final ListOperationCallback<PrivateLinkResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkResourceInner&gt; object
     */
    public Observable<Page<PrivateLinkResourceInner>> listByBatchAccountNextAsync(final String nextPageLink) {
        return listByBatchAccountNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Page<PrivateLinkResourceInner>>() {
                @Override
                public Page<PrivateLinkResourceInner> call(ServiceResponse<Page<PrivateLinkResourceInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateLinkResourceInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountNextWithServiceResponseAsync(final String nextPageLink) {
        return listByBatchAccountNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(ServiceResponse<Page<PrivateLinkResourceInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the private link resources in the specified account.
     *
    ServiceResponse<PageImpl<PrivateLinkResourceInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateLinkResourceInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateLinkResourceInner>> result = listByBatchAccountNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateLinkResourceInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateLinkResourceInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateLinkResourceInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateLinkResourceInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
