/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import java.util.List;
import com.microsoft.azure.management.batch.SkuCapability;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes a Batch supported SKU.
 */
public class SupportedSkuInner {
    /**
     * The name of the SKU.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The family name of the SKU.
     */
    @JsonProperty(value = "familyName", access = JsonProperty.Access.WRITE_ONLY)
    private String familyName;

    /**
     * A collection of capabilities which this SKU supports.
     */
    @JsonProperty(value = "capabilities", access = JsonProperty.Access.WRITE_ONLY)
    private List<SkuCapability> capabilities;

    /**
     * Get the name of the SKU.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the family name of the SKU.
     *
     * @return the familyName value
     */
    public String familyName() {
        return this.familyName;
    }

    /**
     * Get a collection of capabilities which this SKU supports.
     *
     * @return the capabilities value
     */
    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

}
