/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batch.Application;
import com.microsoft.azure.management.batch.BatchAccount;
import com.microsoft.azure.management.batch.implementation.ApplicationImpl;
import com.microsoft.azure.management.batch.implementation.ApplicationInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountImpl;
import com.microsoft.azure.management.batch.implementation.BatchAccountInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.BatchManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@LangDefinition
class ApplicationsImpl
extends ExternalChildResourcesCachedImpl<ApplicationImpl, Application, ApplicationInner, BatchAccountImpl, BatchAccount> {
    ApplicationsImpl(BatchAccountImpl parent) {
        super((Object)parent, parent.taskGroup(), "Application");
        this.cacheCollection();
    }

    public Map<String, Application> asMap() {
        HashMap result = new HashMap();
        for (Map.Entry entry : this.collection().entrySet()) {
            ApplicationImpl application = (ApplicationImpl)entry.getValue();
            result.put(entry.getKey(), application);
        }
        return Collections.unmodifiableMap(result);
    }

    public ApplicationImpl define(String name) {
        return (ApplicationImpl)this.prepareInlineDefine(name);
    }

    public ApplicationImpl update(String name) {
        return (ApplicationImpl)this.prepareInlineUpdate(name);
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addApplication(ApplicationImpl application) {
        this.addChildResource(application);
    }

    protected List<ApplicationImpl> listChildResources() {
        ArrayList<ApplicationImpl> childResources = new ArrayList<ApplicationImpl>();
        if (((BatchAccountInner)((Object)((BatchAccountImpl)this.parent()).inner())).id() == null || ((BatchAccountImpl)this.parent()).autoStorage() == null) {
            return childResources;
        }
        PagedList<ApplicationInner> applicationList = ((BatchManagementClientImpl)((Object)((BatchManager)((BatchAccountImpl)this.parent()).manager()).inner())).applications().list(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name());
        for (ApplicationInner application : applicationList) {
            childResources.add(new ApplicationImpl(application.name(), (BatchAccountImpl)this.parent(), application));
        }
        return childResources;
    }

    protected ApplicationImpl newChildResource(String name) {
        ApplicationImpl application = ApplicationImpl.newApplication(name, (BatchAccountImpl)this.parent());
        return application;
    }
}

