/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.azure.management.batch.implementation.PrivateLinkResourceInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class PrivateLinkResourcesInner {
    private PrivateLinkResourcesService service;
    private BatchManagementClientImpl client;

    public PrivateLinkResourcesInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (PrivateLinkResourcesService)retrofit.create(PrivateLinkResourcesService.class);
        this.client = client;
    }

    public PagedList<PrivateLinkResourceInner> listByBatchAccount(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<PrivateLinkResourceInner>((Page)response.body()){

            public Page<PrivateLinkResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkResourcesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkResourceInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, ListOperationCallback<PrivateLinkResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(String nextPageLink) {
                return PrivateLinkResourcesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkResourceInner>> listByBatchAccountAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Page<PrivateLinkResourceInner>>(){

            public Page<PrivateLinkResourceInner> call(ServiceResponse<Page<PrivateLinkResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(ServiceResponse<Page<PrivateLinkResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkResourcesInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        return this.service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkResourcesInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<PrivateLinkResourceInner> listByBatchAccount(String resourceGroupName, String accountName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults).toBlocking().single();
        return new PagedList<PrivateLinkResourceInner>((Page)response.body()){

            public Page<PrivateLinkResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkResourcesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkResourceInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults, ListOperationCallback<PrivateLinkResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(String nextPageLink) {
                return PrivateLinkResourcesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkResourceInner>> listByBatchAccountAsync(String resourceGroupName, String accountName, Integer maxresults) {
        return this.listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults).map((Func1)new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Page<PrivateLinkResourceInner>>(){

            public Page<PrivateLinkResourceInner> call(ServiceResponse<Page<PrivateLinkResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountWithServiceResponseAsync(String resourceGroupName, String accountName, Integer maxresults) {
        return this.listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(ServiceResponse<Page<PrivateLinkResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkResourcesInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountSinglePageAsync(String resourceGroupName, String accountName, Integer maxresults) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkResourcesInner.this.listByBatchAccountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkResourceInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PrivateLinkResourceInner get(String resourceGroupName, String accountName, String privateLinkResourceName) {
        return (PrivateLinkResourceInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, privateLinkResourceName).toBlocking().single()).body());
    }

    public ServiceFuture<PrivateLinkResourceInner> getAsync(String resourceGroupName, String accountName, String privateLinkResourceName, ServiceCallback<PrivateLinkResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, privateLinkResourceName), serviceCallback);
    }

    public Observable<PrivateLinkResourceInner> getAsync(String resourceGroupName, String accountName, String privateLinkResourceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, privateLinkResourceName).map((Func1)new Func1<ServiceResponse<PrivateLinkResourceInner>, PrivateLinkResourceInner>(){

            public PrivateLinkResourceInner call(ServiceResponse<PrivateLinkResourceInner> response) {
                return (PrivateLinkResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<PrivateLinkResourceInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String privateLinkResourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateLinkResourceName == null) {
            throw new IllegalArgumentException("Parameter privateLinkResourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, accountName, privateLinkResourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateLinkResourceInner>>>(){

            public Observable<ServiceResponse<PrivateLinkResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = PrivateLinkResourcesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PrivateLinkResourceInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PrivateLinkResourceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<PrivateLinkResourceInner> listByBatchAccountNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateLinkResourceInner>((Page)response.body()){

            public Page<PrivateLinkResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)PrivateLinkResourcesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<PrivateLinkResourceInner>> listByBatchAccountNextAsync(String nextPageLink, ServiceFuture<List<PrivateLinkResourceInner>> serviceFuture, ListOperationCallback<PrivateLinkResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByBatchAccountNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(String nextPageLink) {
                return PrivateLinkResourcesInner.this.listByBatchAccountNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<PrivateLinkResourceInner>> listByBatchAccountNextAsync(String nextPageLink) {
        return this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Page<PrivateLinkResourceInner>>(){

            public Page<PrivateLinkResourceInner> call(ServiceResponse<Page<PrivateLinkResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByBatchAccountNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<PrivateLinkResourceInner>>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(ServiceResponse<Page<PrivateLinkResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(PrivateLinkResourcesInner.this.listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> listByBatchAccountNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateLinkResourceInner>>>>(){

            public Observable<ServiceResponse<Page<PrivateLinkResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PrivateLinkResourcesInner.this.listByBatchAccountNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PrivateLinkResourceInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PrivateLinkResourceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateLinkResources listByBatchAccount"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateLinkResources")
        public Observable<Response<ResponseBody>> listByBatchAccount(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Query(value="maxresults") Integer var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateLinkResources get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateLinkResources/{privateLinkResourceName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="privateLinkResourceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateLinkResources listByBatchAccountNext"})
        @GET
        public Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

