/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AutoStorageAuthenticationMode.
 */
public enum AutoStorageAuthenticationMode {
    /** The Batch service will authenticate requests to auto-storage using storage account keys. */
    STORAGE_KEYS("StorageKeys"),

    /** The Batch service will authenticate requests to auto-storage using the managed identity assigned to the Batch account. */
    BATCH_ACCOUNT_MANAGED_IDENTITY("BatchAccountManagedIdentity");

    /** The actual serialized value for a AutoStorageAuthenticationMode instance. */
    private String value;

    AutoStorageAuthenticationMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AutoStorageAuthenticationMode instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed AutoStorageAuthenticationMode object, or null if unable to parse.
     */
    @JsonCreator
    public static AutoStorageAuthenticationMode fromString(String value) {
        AutoStorageAuthenticationMode[] items = AutoStorageAuthenticationMode.values();
        for (AutoStorageAuthenticationMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
