/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies the parameters for the auto user that runs a task on the Batch
 * service.
 */
public class AutoUserSpecification {
    /**
     * The scope for the auto user.
     * The default value is Pool. If the pool is running Windows a value of
     * Task should be specified if stricter isolation between tasks is
     * required. For example, if the task mutates the registry in a way which
     * could impact other tasks, or if certificates have been specified on the
     * pool which should not be accessible by normal tasks but should be
     * accessible by start tasks. Possible values include: 'Task', 'Pool'.
     */
    @JsonProperty(value = "scope")
    private AutoUserScope scope;

    /**
     * The elevation level of the auto user.
     * The default value is nonAdmin. Possible values include: 'NonAdmin',
     * 'Admin'.
     */
    @JsonProperty(value = "elevationLevel")
    private ElevationLevel elevationLevel;

    /**
     * Get the default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks. Possible values include: 'Task', 'Pool'.
     *
     * @return the scope value
     */
    public AutoUserScope scope() {
        return this.scope;
    }

    /**
     * Set the default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks. Possible values include: 'Task', 'Pool'.
     *
     * @param scope the scope value to set
     * @return the AutoUserSpecification object itself.
     */
    public AutoUserSpecification withScope(AutoUserScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'.
     *
     * @return the elevationLevel value
     */
    public ElevationLevel elevationLevel() {
        return this.elevationLevel;
    }

    /**
     * Set the default value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'.
     *
     * @param elevationLevel the elevationLevel value to set
     * @return the AutoUserSpecification object itself.
     */
    public AutoUserSpecification withElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

}
