/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.Map;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Parameters supplied to the Create operation.
 */
@JsonFlatten
public class BatchAccountCreateParameters {
    /**
     * The region in which to create the account.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The user-specified tags associated with the account.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * The properties related to the auto-storage account.
     */
    @JsonProperty(value = "properties.autoStorage")
    private AutoStorageBaseProperties autoStorage;

    /**
     * The allocation mode to use for creating pools in the Batch account.
     * The pool allocation mode also affects how clients may authenticate to
     * the Batch Service API. If the mode is BatchService, clients may
     * authenticate using access keys or Azure Active Directory. If the mode is
     * UserSubscription, clients must use Azure Active Directory. The default
     * is BatchService. Possible values include: 'BatchService',
     * 'UserSubscription'.
     */
    @JsonProperty(value = "properties.poolAllocationMode")
    private PoolAllocationMode poolAllocationMode;

    /**
     * A reference to the Azure key vault associated with the Batch account.
     */
    @JsonProperty(value = "properties.keyVaultReference")
    private KeyVaultReference keyVaultReference;

    /**
     * The network access type for accessing Azure Batch account.
     * If not specified, the default value is 'enabled'. Possible values
     * include: 'Enabled', 'Disabled'.
     */
    @JsonProperty(value = "properties.publicNetworkAccess")
    private PublicNetworkAccessType publicNetworkAccess;

    /**
     * The encryption configuration for the Batch account.
     * Configures how customer data is encrypted inside the Batch account. By
     * default, accounts are encrypted using a Microsoft managed key. For
     * additional control, a customer-managed key can be used instead.
     */
    @JsonProperty(value = "properties.encryption")
    private EncryptionProperties encryption;

    /**
     * List of allowed authentication modes for the Batch account that can be
     * used to authenticate with the data plane. This does not affect
     * authentication with the control plane.
     */
    @JsonProperty(value = "properties.allowedAuthenticationModes")
    private List<AuthenticationMode> allowedAuthenticationModes;

    /**
     * The identity of the Batch account.
     */
    @JsonProperty(value = "identity")
    private BatchAccountIdentity identity;

    /**
     * Get the region in which to create the account.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the region in which to create the account.
     *
     * @param location the location value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the user-specified tags associated with the account.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the user-specified tags associated with the account.
     *
     * @param tags the tags value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties related to the auto-storage account.
     *
     * @return the autoStorage value
     */
    public AutoStorageBaseProperties autoStorage() {
        return this.autoStorage;
    }

    /**
     * Set the properties related to the auto-storage account.
     *
     * @param autoStorage the autoStorage value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withAutoStorage(AutoStorageBaseProperties autoStorage) {
        this.autoStorage = autoStorage;
        return this;
    }

    /**
     * Get the pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService. Possible values include: 'BatchService', 'UserSubscription'.
     *
     * @return the poolAllocationMode value
     */
    public PoolAllocationMode poolAllocationMode() {
        return this.poolAllocationMode;
    }

    /**
     * Set the pool allocation mode also affects how clients may authenticate to the Batch Service API. If the mode is BatchService, clients may authenticate using access keys or Azure Active Directory. If the mode is UserSubscription, clients must use Azure Active Directory. The default is BatchService. Possible values include: 'BatchService', 'UserSubscription'.
     *
     * @param poolAllocationMode the poolAllocationMode value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withPoolAllocationMode(PoolAllocationMode poolAllocationMode) {
        this.poolAllocationMode = poolAllocationMode;
        return this;
    }

    /**
     * Get a reference to the Azure key vault associated with the Batch account.
     *
     * @return the keyVaultReference value
     */
    public KeyVaultReference keyVaultReference() {
        return this.keyVaultReference;
    }

    /**
     * Set a reference to the Azure key vault associated with the Batch account.
     *
     * @param keyVaultReference the keyVaultReference value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withKeyVaultReference(KeyVaultReference keyVaultReference) {
        this.keyVaultReference = keyVaultReference;
        return this;
    }

    /**
     * Get if not specified, the default value is 'enabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @return the publicNetworkAccess value
     */
    public PublicNetworkAccessType publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set if not specified, the default value is 'enabled'. Possible values include: 'Enabled', 'Disabled'.
     *
     * @param publicNetworkAccess the publicNetworkAccess value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withPublicNetworkAccess(PublicNetworkAccessType publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     *
     * @return the encryption value
     */
    public EncryptionProperties encryption() {
        return this.encryption;
    }

    /**
     * Set configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a Microsoft managed key. For additional control, a customer-managed key can be used instead.
     *
     * @param encryption the encryption value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    /**
     * Get list of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     *
     * @return the allowedAuthenticationModes value
     */
    public List<AuthenticationMode> allowedAuthenticationModes() {
        return this.allowedAuthenticationModes;
    }

    /**
     * Set list of allowed authentication modes for the Batch account that can be used to authenticate with the data plane. This does not affect authentication with the control plane.
     *
     * @param allowedAuthenticationModes the allowedAuthenticationModes value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withAllowedAuthenticationModes(List<AuthenticationMode> allowedAuthenticationModes) {
        this.allowedAuthenticationModes = allowedAuthenticationModes;
        return this;
    }

    /**
     * Get the identity of the Batch account.
     *
     * @return the identity value
     */
    public BatchAccountIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity of the Batch account.
     *
     * @param identity the identity value to set
     * @return the BatchAccountCreateParameters object itself.
     */
    public BatchAccountCreateParameters withIdentity(BatchAccountIdentity identity) {
        this.identity = identity;
        return this;
    }

}
