/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Node placement configuration for batch pools.
 * Allocation configuration used by Batch Service to provision the nodes.
 */
public class NodePlacementConfiguration {
    /**
     * Node placement Policy type on Batch Pools.
     * Allocation policy used by Batch Service to provision the nodes. If not
     * specified, Batch will use the regional policy. Possible values include:
     * 'Regional', 'Zonal'.
     */
    @JsonProperty(value = "policy")
    private NodePlacementPolicyType policy;

    /**
     * Get allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy. Possible values include: 'Regional', 'Zonal'.
     *
     * @return the policy value
     */
    public NodePlacementPolicyType policy() {
        return this.policy;
    }

    /**
     * Set allocation policy used by Batch Service to provision the nodes. If not specified, Batch will use the regional policy. Possible values include: 'Regional', 'Zonal'.
     *
     * @param policy the policy value to set
     * @return the NodePlacementConfiguration object itself.
     */
    public NodePlacementConfiguration withPolicy(NodePlacementPolicyType policy) {
        this.policy = policy;
        return this;
    }

}
