/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for NodePlacementPolicyType.
 */
public enum NodePlacementPolicyType {
    /** All nodes in the pool will be allocated in the same region. */
    REGIONAL("Regional"),

    /** Nodes in the pool will be spread across different zones with best effort balancing. */
    ZONAL("Zonal");

    /** The actual serialized value for a NodePlacementPolicyType instance. */
    private String value;

    NodePlacementPolicyType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NodePlacementPolicyType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed NodePlacementPolicyType object, or null if unable to parse.
     */
    @JsonCreator
    public static NodePlacementPolicyType fromString(String value) {
        NodePlacementPolicyType[] items = NodePlacementPolicyType.values();
        for (NodePlacementPolicyType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
