/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PrivateEndpointConnectionProvisioningState.
 */
public enum PrivateEndpointConnectionProvisioningState {
    /** The connection status is final and is ready for use if Status is Approved. */
    SUCCEEDED("Succeeded"),

    /** The user has requested that the connection status be updated, but the update operation has not yet completed. You may not reference the connection when connecting the Batch account. */
    UPDATING("Updating"),

    /** The user requested that the connection be updated and it failed. You may retry the update operation. */
    FAILED("Failed");

    /** The actual serialized value for a PrivateEndpointConnectionProvisioningState instance. */
    private String value;

    PrivateEndpointConnectionProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PrivateEndpointConnectionProvisioningState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PrivateEndpointConnectionProvisioningState object, or null if unable to parse.
     */
    @JsonCreator
    public static PrivateEndpointConnectionProvisioningState fromString(String value) {
        PrivateEndpointConnectionProvisioningState[] items = PrivateEndpointConnectionProvisioningState.values();
        for (PrivateEndpointConnectionProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
