/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.batch.PrivateEndpointConnectionUpdateHeaders;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in PrivateEndpointConnections.
 */
public class PrivateEndpointConnectionsInner {
    /** The Retrofit service to perform REST calls. */
    private PrivateEndpointConnectionsService service;
    /** The service client containing this operation class. */
    private BatchManagementClientImpl client;

    /**
     * Initializes an instance of PrivateEndpointConnectionsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public PrivateEndpointConnectionsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = retrofit.create(PrivateEndpointConnectionsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for PrivateEndpointConnections to be
     * used by Retrofit to perform actually REST calls.
     */
    interface PrivateEndpointConnectionsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections listByBatchAccount" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections")
        Observable<Response<ResponseBody>> listByBatchAccount(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Query("api-version") String apiVersion, @Query("maxresults") Integer maxresults, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}")
        Observable<Response<ResponseBody>> get(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}")
        Observable<Response<ResponseBody>> update(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Body PrivateEndpointConnectionInner parameters, @Header("If-Match") String ifMatch, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections beginUpdate" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/privateEndpointConnections/{privateEndpointConnectionName}")
        Observable<Response<ResponseBody>> beginUpdate(@Path("subscriptionId") String subscriptionId, @Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("privateEndpointConnectionName") String privateEndpointConnectionName, @Query("api-version") String apiVersion, @Body PrivateEndpointConnectionInner parameters, @Header("If-Match") String ifMatch, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.PrivateEndpointConnections listByBatchAccountNext" })
        @GET
        Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listByBatchAccount(final String resourceGroupName, final String accountName) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer maxresults = null;
        return service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listByBatchAccount(final String resourceGroupName, final String accountName, final Integer maxresults) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName, final Integer maxresults) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param resourceGroupName The name of the resource group that contains the Batch account.
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param accountName The name of the Batch account.
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param maxresults The maximum number of items to return in the response.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName, final Integer maxresults) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByBatchAccount(this.client.subscriptionId(), resourceGroupName, accountName, this.client.apiVersion(), maxresults, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateEndpointConnectionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about the specified private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner get(String resourceGroupName, String accountName, String privateEndpointConnectionName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName).toBlocking().single().body();
    }

    /**
     * Gets information about the specified private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName), serviceCallback);
    }

    /**
     * Gets information about the specified private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> getAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName).map(new Func1<ServiceResponse<PrivateEndpointConnectionInner>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponse<PrivateEndpointConnectionInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about the specified private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponse<PrivateEndpointConnectionInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<PrivateEndpointConnectionInner>>>() {
                @Override
                public Observable<ServiceResponse<PrivateEndpointConnectionInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PrivateEndpointConnectionInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PrivateEndpointConnectionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateEndpointConnectionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner update(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).toBlocking().last().body();
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters), serviceCallback);
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).map(new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultWithHeadersAsync(observable, new TypeToken<PrivateEndpointConnectionInner>() { }.getType(), PrivateEndpointConnectionUpdateHeaders.class);
    }
    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner update(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).toBlocking().last().body();
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch), serviceCallback);
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<PrivateEndpointConnectionInner> updateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).map(new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.update(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultWithHeadersAsync(observable, new TypeToken<PrivateEndpointConnectionInner>() { }.getType(), PrivateEndpointConnectionUpdateHeaders.class);
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner beginUpdate(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).toBlocking().single().body();
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters), serviceCallback);
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters).map(new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PrivateEndpointConnectionInner object if successful.
     */
    public PrivateEndpointConnectionInner beginUpdate(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).toBlocking().single().body();
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch, final ServiceCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch), serviceCallback);
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<PrivateEndpointConnectionInner> beginUpdateAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        return beginUpdateWithServiceResponseAsync(resourceGroupName, accountName, privateEndpointConnectionName, parameters, ifMatch).map(new Func1<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>, PrivateEndpointConnectionInner>() {
            @Override
            public PrivateEndpointConnectionInner call(ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing private endpoint connection.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param privateEndpointConnectionName The private endpoint connection name. This must be unique within the account.
     * @param parameters PrivateEndpointConnection properties that should be updated. Properties that are supplied will be updated, any property not supplied will be unchanged.
     * @param ifMatch The state (ETag) version of the private endpoint connection to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PrivateEndpointConnectionInner object
     */
    public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String accountName, String privateEndpointConnectionName, PrivateEndpointConnectionInner parameters, String ifMatch) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (privateEndpointConnectionName == null) {
            throw new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginUpdate(this.client.subscriptionId(), resourceGroupName, accountName, privateEndpointConnectionName, this.client.apiVersion(), parameters, ifMatch, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> clientResponse = beginUpdateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<PrivateEndpointConnectionInner, PrivateEndpointConnectionUpdateHeaders> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PrivateEndpointConnectionInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PrivateEndpointConnectionInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, PrivateEndpointConnectionUpdateHeaders.class);
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object if successful.
     */
    public PagedList<PrivateEndpointConnectionInner> listByBatchAccountNext(final String nextPageLink) {
        ServiceResponse<Page<PrivateEndpointConnectionInner>> response = listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<PrivateEndpointConnectionInner>(response.body()) {
            @Override
            public Page<PrivateEndpointConnectionInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<PrivateEndpointConnectionInner>> listByBatchAccountNextAsync(final String nextPageLink, final ServiceFuture<List<PrivateEndpointConnectionInner>> serviceFuture, final ListOperationCallback<PrivateEndpointConnectionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<Page<PrivateEndpointConnectionInner>> listByBatchAccountNextAsync(final String nextPageLink) {
        return listByBatchAccountNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Page<PrivateEndpointConnectionInner>>() {
                @Override
                public Page<PrivateEndpointConnectionInner> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;PrivateEndpointConnectionInner&gt; object
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountNextWithServiceResponseAsync(final String nextPageLink) {
        return listByBatchAccountNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<PrivateEndpointConnectionInner>>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(ServiceResponse<Page<PrivateEndpointConnectionInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the private endpoint connections in the specified account.
     *
    ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;PrivateEndpointConnectionInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> listByBatchAccountNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<PrivateEndpointConnectionInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> result = listByBatchAccountNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<PrivateEndpointConnectionInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<PrivateEndpointConnectionInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<PrivateEndpointConnectionInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<PrivateEndpointConnectionInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
