/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.batch.implementation.ApplicationPackagesInner;
import com.microsoft.azure.management.batch.implementation.ApplicationsInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountsInner;
import com.microsoft.azure.management.batch.implementation.CertificatesInner;
import com.microsoft.azure.management.batch.implementation.LocationsInner;
import com.microsoft.azure.management.batch.implementation.OperationsInner;
import com.microsoft.azure.management.batch.implementation.PoolsInner;
import com.microsoft.azure.management.batch.implementation.PrivateEndpointConnectionsInner;
import com.microsoft.azure.management.batch.implementation.PrivateLinkResourcesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class BatchManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private BatchAccountsInner batchAccounts;
    private ApplicationPackagesInner applicationPackages;
    private ApplicationsInner applications;
    private LocationsInner locations;
    private OperationsInner operations;
    private CertificatesInner certificates;
    private PrivateLinkResourcesInner privateLinkResources;
    private PrivateEndpointConnectionsInner privateEndpointConnections;
    private PoolsInner pools;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public BatchManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public BatchManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public BatchManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public BatchManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public BatchAccountsInner batchAccounts() {
        return this.batchAccounts;
    }

    public ApplicationPackagesInner applicationPackages() {
        return this.applicationPackages;
    }

    public ApplicationsInner applications() {
        return this.applications;
    }

    public LocationsInner locations() {
        return this.locations;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public CertificatesInner certificates() {
        return this.certificates;
    }

    public PrivateLinkResourcesInner privateLinkResources() {
        return this.privateLinkResources;
    }

    public PrivateEndpointConnectionsInner privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PoolsInner pools() {
        return this.pools;
    }

    public BatchManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public BatchManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public BatchManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2021-06-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.batchAccounts = new BatchAccountsInner(this.restClient().retrofit(), this);
        this.applicationPackages = new ApplicationPackagesInner(this.restClient().retrofit(), this);
        this.applications = new ApplicationsInner(this.restClient().retrofit(), this);
        this.locations = new LocationsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.certificates = new CertificatesInner(this.restClient().retrofit(), this);
        this.privateLinkResources = new PrivateLinkResourcesInner(this.restClient().retrofit(), this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsInner(this.restClient().retrofit(), this);
        this.pools = new PoolsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "BatchManagementClient", "2021-06-01");
    }
}

