/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.CheckNameAvailabilityParameters;
import com.microsoft.azure.management.batch.implementation.BatchLocationQuotaInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.CheckNameAvailabilityResultInner;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.azure.management.batch.implementation.SupportedSkuInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class LocationsInner {
    private LocationsService service;
    private BatchManagementClientImpl client;

    public LocationsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (LocationsService)retrofit.create(LocationsService.class);
        this.client = client;
    }

    public BatchLocationQuotaInner getQuotas(String locationName) {
        return (BatchLocationQuotaInner)((ServiceResponse)this.getQuotasWithServiceResponseAsync(locationName).toBlocking().single()).body();
    }

    public ServiceFuture<BatchLocationQuotaInner> getQuotasAsync(String locationName, ServiceCallback<BatchLocationQuotaInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getQuotasWithServiceResponseAsync(locationName), serviceCallback);
    }

    public Observable<BatchLocationQuotaInner> getQuotasAsync(String locationName) {
        return this.getQuotasWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<BatchLocationQuotaInner>, BatchLocationQuotaInner>(){

            public BatchLocationQuotaInner call(ServiceResponse<BatchLocationQuotaInner> response) {
                return (BatchLocationQuotaInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BatchLocationQuotaInner>> getQuotasWithServiceResponseAsync(String locationName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getQuotas(locationName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BatchLocationQuotaInner>>>(){

            public Observable<ServiceResponse<BatchLocationQuotaInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocationsInner.this.getQuotasDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BatchLocationQuotaInner> getQuotasDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BatchLocationQuotaInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SupportedSkuInner> listSupportedVirtualMachineSkus(String locationName) {
        ServiceResponse response = (ServiceResponse)this.listSupportedVirtualMachineSkusSinglePageAsync(locationName).toBlocking().single();
        return new PagedList<SupportedSkuInner>((Page)response.body()){

            public Page<SupportedSkuInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SupportedSkuInner>> listSupportedVirtualMachineSkusAsync(String locationName, ListOperationCallback<SupportedSkuInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSupportedVirtualMachineSkusSinglePageAsync(locationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(String nextPageLink) {
                return LocationsInner.this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SupportedSkuInner>> listSupportedVirtualMachineSkusAsync(String locationName) {
        return this.listSupportedVirtualMachineSkusWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Page<SupportedSkuInner>>(){

            public Page<SupportedSkuInner> call(ServiceResponse<Page<SupportedSkuInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedVirtualMachineSkusWithServiceResponseAsync(String locationName) {
        return this.listSupportedVirtualMachineSkusSinglePageAsync(locationName).concatMap((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(ServiceResponse<Page<SupportedSkuInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listSupportedVirtualMachineSkusNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedVirtualMachineSkusSinglePageAsync(String locationName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String filter = null;
        return this.service.listSupportedVirtualMachineSkus(locationName, this.client.subscriptionId(), maxresults, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listSupportedVirtualMachineSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<SupportedSkuInner> listSupportedVirtualMachineSkus(String locationName, Integer maxresults, String filter) {
        ServiceResponse response = (ServiceResponse)this.listSupportedVirtualMachineSkusSinglePageAsync(locationName, maxresults, filter).toBlocking().single();
        return new PagedList<SupportedSkuInner>((Page)response.body()){

            public Page<SupportedSkuInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SupportedSkuInner>> listSupportedVirtualMachineSkusAsync(String locationName, Integer maxresults, String filter, ListOperationCallback<SupportedSkuInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSupportedVirtualMachineSkusSinglePageAsync(locationName, maxresults, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(String nextPageLink) {
                return LocationsInner.this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SupportedSkuInner>> listSupportedVirtualMachineSkusAsync(String locationName, Integer maxresults, String filter) {
        return this.listSupportedVirtualMachineSkusWithServiceResponseAsync(locationName, maxresults, filter).map((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Page<SupportedSkuInner>>(){

            public Page<SupportedSkuInner> call(ServiceResponse<Page<SupportedSkuInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedVirtualMachineSkusWithServiceResponseAsync(String locationName, Integer maxresults, String filter) {
        return this.listSupportedVirtualMachineSkusSinglePageAsync(locationName, maxresults, filter).concatMap((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(ServiceResponse<Page<SupportedSkuInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listSupportedVirtualMachineSkusNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedVirtualMachineSkusSinglePageAsync(String locationName, Integer maxresults, String filter) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSupportedVirtualMachineSkus(locationName, this.client.subscriptionId(), maxresults, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listSupportedVirtualMachineSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SupportedSkuInner>> listSupportedVirtualMachineSkusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SupportedSkuInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SupportedSkuInner> listSupportedCloudServiceSkus(String locationName) {
        ServiceResponse response = (ServiceResponse)this.listSupportedCloudServiceSkusSinglePageAsync(locationName).toBlocking().single();
        return new PagedList<SupportedSkuInner>((Page)response.body()){

            public Page<SupportedSkuInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SupportedSkuInner>> listSupportedCloudServiceSkusAsync(String locationName, ListOperationCallback<SupportedSkuInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSupportedCloudServiceSkusSinglePageAsync(locationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(String nextPageLink) {
                return LocationsInner.this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SupportedSkuInner>> listSupportedCloudServiceSkusAsync(String locationName) {
        return this.listSupportedCloudServiceSkusWithServiceResponseAsync(locationName).map((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Page<SupportedSkuInner>>(){

            public Page<SupportedSkuInner> call(ServiceResponse<Page<SupportedSkuInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedCloudServiceSkusWithServiceResponseAsync(String locationName) {
        return this.listSupportedCloudServiceSkusSinglePageAsync(locationName).concatMap((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(ServiceResponse<Page<SupportedSkuInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listSupportedCloudServiceSkusNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedCloudServiceSkusSinglePageAsync(String locationName) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String filter = null;
        return this.service.listSupportedCloudServiceSkus(locationName, this.client.subscriptionId(), maxresults, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listSupportedCloudServiceSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<SupportedSkuInner> listSupportedCloudServiceSkus(String locationName, Integer maxresults, String filter) {
        ServiceResponse response = (ServiceResponse)this.listSupportedCloudServiceSkusSinglePageAsync(locationName, maxresults, filter).toBlocking().single();
        return new PagedList<SupportedSkuInner>((Page)response.body()){

            public Page<SupportedSkuInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SupportedSkuInner>> listSupportedCloudServiceSkusAsync(String locationName, Integer maxresults, String filter, ListOperationCallback<SupportedSkuInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSupportedCloudServiceSkusSinglePageAsync(locationName, maxresults, filter), (Func1)new Func1<String, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(String nextPageLink) {
                return LocationsInner.this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SupportedSkuInner>> listSupportedCloudServiceSkusAsync(String locationName, Integer maxresults, String filter) {
        return this.listSupportedCloudServiceSkusWithServiceResponseAsync(locationName, maxresults, filter).map((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Page<SupportedSkuInner>>(){

            public Page<SupportedSkuInner> call(ServiceResponse<Page<SupportedSkuInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedCloudServiceSkusWithServiceResponseAsync(String locationName, Integer maxresults, String filter) {
        return this.listSupportedCloudServiceSkusSinglePageAsync(locationName, maxresults, filter).concatMap((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(ServiceResponse<Page<SupportedSkuInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listSupportedCloudServiceSkusNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedCloudServiceSkusSinglePageAsync(String locationName, Integer maxresults, String filter) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSupportedCloudServiceSkus(locationName, this.client.subscriptionId(), maxresults, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listSupportedCloudServiceSkusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SupportedSkuInner>> listSupportedCloudServiceSkusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SupportedSkuInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CheckNameAvailabilityResultInner checkNameAvailability(String locationName, String name) {
        return (CheckNameAvailabilityResultInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(locationName, name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String locationName, String name, ServiceCallback<CheckNameAvailabilityResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(locationName, name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(String locationName, String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(locationName, name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityResultInner>, CheckNameAvailabilityResultInner>(){

            public CheckNameAvailabilityResultInner call(ServiceResponse<CheckNameAvailabilityResultInner> response) {
                return (CheckNameAvailabilityResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithServiceResponseAsync(String locationName, String name) {
        if (locationName == null) {
            throw new IllegalArgumentException("Parameter locationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityParameters parameters = new CheckNameAvailabilityParameters();
        parameters.withName(name);
        return this.service.checkNameAvailability(locationName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityResultInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = LocationsInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityResultInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SupportedSkuInner> listSupportedVirtualMachineSkusNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SupportedSkuInner>((Page)response.body()){

            public Page<SupportedSkuInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SupportedSkuInner>> listSupportedVirtualMachineSkusNextAsync(String nextPageLink, ServiceFuture<List<SupportedSkuInner>> serviceFuture, ListOperationCallback<SupportedSkuInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(String nextPageLink) {
                return LocationsInner.this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SupportedSkuInner>> listSupportedVirtualMachineSkusNextAsync(String nextPageLink) {
        return this.listSupportedVirtualMachineSkusNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Page<SupportedSkuInner>>(){

            public Page<SupportedSkuInner> call(ServiceResponse<Page<SupportedSkuInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedVirtualMachineSkusNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSupportedVirtualMachineSkusNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(ServiceResponse<Page<SupportedSkuInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listSupportedVirtualMachineSkusNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedVirtualMachineSkusNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSupportedVirtualMachineSkusNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listSupportedVirtualMachineSkusNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SupportedSkuInner>> listSupportedVirtualMachineSkusNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SupportedSkuInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SupportedSkuInner> listSupportedCloudServiceSkusNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SupportedSkuInner>((Page)response.body()){

            public Page<SupportedSkuInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)LocationsInner.this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SupportedSkuInner>> listSupportedCloudServiceSkusNextAsync(String nextPageLink, ServiceFuture<List<SupportedSkuInner>> serviceFuture, ListOperationCallback<SupportedSkuInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(String nextPageLink) {
                return LocationsInner.this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SupportedSkuInner>> listSupportedCloudServiceSkusNextAsync(String nextPageLink) {
        return this.listSupportedCloudServiceSkusNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Page<SupportedSkuInner>>(){

            public Page<SupportedSkuInner> call(ServiceResponse<Page<SupportedSkuInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedCloudServiceSkusNextWithServiceResponseAsync(String nextPageLink) {
        return this.listSupportedCloudServiceSkusNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SupportedSkuInner>>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(ServiceResponse<Page<SupportedSkuInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(LocationsInner.this.listSupportedCloudServiceSkusNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SupportedSkuInner>>> listSupportedCloudServiceSkusNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listSupportedCloudServiceSkusNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SupportedSkuInner>>>>(){

            public Observable<ServiceResponse<Page<SupportedSkuInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = LocationsInner.this.listSupportedCloudServiceSkusNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SupportedSkuInner>> listSupportedCloudServiceSkusNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SupportedSkuInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface LocationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations getQuotas"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/quotas")
        public Observable<Response<ResponseBody>> getQuotas(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations listSupportedVirtualMachineSkus"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/virtualMachineSkus")
        public Observable<Response<ResponseBody>> listSupportedVirtualMachineSkus(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="maxresults") Integer var3, @Query(value="$filter") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations listSupportedCloudServiceSkus"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/cloudServiceSkus")
        public Observable<Response<ResponseBody>> listSupportedCloudServiceSkus(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="maxresults") Integer var3, @Query(value="$filter") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Batch/locations/{locationName}/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="locationName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body CheckNameAvailabilityParameters var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations listSupportedVirtualMachineSkusNext"})
        @GET
        public Observable<Response<ResponseBody>> listSupportedVirtualMachineSkusNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Locations listSupportedCloudServiceSkusNext"})
        @GET
        public Observable<Response<ResponseBody>> listSupportedCloudServiceSkusNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

