/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for AuthenticationMode.
 */
public enum AuthenticationMode {
    /** The authentication mode using shared keys. */
    SHARED_KEY("SharedKey"),

    /** The authentication mode using Azure Active Directory. */
    AAD("AAD"),

    /** The authentication mode using task authentication tokens. */
    TASK_AUTHENTICATION_TOKEN("TaskAuthenticationToken");

    /** The actual serialized value for a AuthenticationMode instance. */
    private String value;

    AuthenticationMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AuthenticationMode instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed AuthenticationMode object, or null if unable to parse.
     */
    @JsonCreator
    public static AuthenticationMode fromString(String value) {
        AuthenticationMode[] items = AuthenticationMode.values();
        for (AuthenticationMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
