/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Configures how customer data is encrypted inside the Batch account. By
 * default, accounts are encrypted using a Microsoft managed key. For
 * additional control, a customer-managed key can be used instead.
 */
public class EncryptionProperties {
    /**
     * Type of the key source. Possible values include: 'Microsoft.Batch',
     * 'Microsoft.KeyVault'.
     */
    @JsonProperty(value = "keySource")
    private KeySource keySource;

    /**
     * Additional details when using Microsoft.KeyVault.
     */
    @JsonProperty(value = "keyVaultProperties")
    private KeyVaultProperties keyVaultProperties;

    /**
     * Get type of the key source. Possible values include: 'Microsoft.Batch', 'Microsoft.KeyVault'.
     *
     * @return the keySource value
     */
    public KeySource keySource() {
        return this.keySource;
    }

    /**
     * Set type of the key source. Possible values include: 'Microsoft.Batch', 'Microsoft.KeyVault'.
     *
     * @param keySource the keySource value to set
     * @return the EncryptionProperties object itself.
     */
    public EncryptionProperties withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    /**
     * Get additional details when using Microsoft.KeyVault.
     *
     * @return the keyVaultProperties value
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set additional details when using Microsoft.KeyVault.
     *
     * @param keyVaultProperties the keyVaultProperties value to set
     * @return the EncryptionProperties object itself.
     */
    public EncryptionProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

}
