/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for KeySource.
 */
public enum KeySource {
    /** Batch creates and manages the encryption keys used to protect the account data. */
    MICROSOFT_BATCH("Microsoft.Batch"),

    /** The encryption keys used to protect the account data are stored in an external key vault. If this is set then the Batch Account identity must be set to `SystemAssigned` and a valid Key Identifier must also be supplied under the keyVaultProperties. */
    MICROSOFT_KEY_VAULT("Microsoft.KeyVault");

    /** The actual serialized value for a KeySource instance. */
    private String value;

    KeySource(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a KeySource instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed KeySource object, or null if unable to parse.
     */
    @JsonCreator
    public static KeySource fromString(String value) {
        KeySource[] items = KeySource.values();
        for (KeySource item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
