/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PoolIdentityType.
 */
public enum PoolIdentityType {
    /** Batch pool has user assigned identities with it. */
    USER_ASSIGNED("UserAssigned"),

    /** Batch pool has no identity associated with it. Setting `None` in update pool will remove existing identities. */
    NONE("None");

    /** The actual serialized value for a PoolIdentityType instance. */
    private String value;

    PoolIdentityType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PoolIdentityType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PoolIdentityType object, or null if unable to parse.
     */
    @JsonCreator
    public static PoolIdentityType fromString(String value) {
        PoolIdentityType[] items = PoolIdentityType.values();
        for (PoolIdentityType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
