/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The private link service connection state of the private endpoint
 * connection.
 */
public class PrivateLinkServiceConnectionState {
    /**
     * The status for the private endpoint connection of Batch account.
     * Possible values include: 'Approved', 'Pending', 'Rejected',
     * 'Disconnected'.
     */
    @JsonProperty(value = "status", required = true)
    private PrivateLinkServiceConnectionStatus status;

    /**
     * Description of the private Connection state.
     */
    @JsonProperty(value = "description")
    private String description;

    /**
     * Action required on the private connection state.
     */
    @JsonProperty(value = "actionRequired", access = JsonProperty.Access.WRITE_ONLY)
    private String actionRequired;

    /**
     * Get possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'.
     *
     * @return the status value
     */
    public PrivateLinkServiceConnectionStatus status() {
        return this.status;
    }

    /**
     * Set possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'.
     *
     * @param status the status value to set
     * @return the PrivateLinkServiceConnectionState object itself.
     */
    public PrivateLinkServiceConnectionState withStatus(PrivateLinkServiceConnectionStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the description value.
     *
     * @return the description value
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description value.
     *
     * @param description the description value to set
     * @return the PrivateLinkServiceConnectionState object itself.
     */
    public PrivateLinkServiceConnectionState withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actionRequired value.
     *
     * @return the actionRequired value
     */
    public String actionRequired() {
        return this.actionRequired;
    }

}
