/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for PublicNetworkAccessType.
 */
public enum PublicNetworkAccessType {
    /** Enables connectivity to Azure Batch through public DNS. */
    ENABLED("Enabled"),

    /** Disables public connectivity and enables private connectivity to Azure Batch Service through private endpoint resource. */
    DISABLED("Disabled");

    /** The actual serialized value for a PublicNetworkAccessType instance. */
    private String value;

    PublicNetworkAccessType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PublicNetworkAccessType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PublicNetworkAccessType object, or null if unable to parse.
     */
    @JsonCreator
    public static PublicNetworkAccessType fromString(String value) {
        PublicNetworkAccessType[] items = PublicNetworkAccessType.values();
        for (PublicNetworkAccessType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
