/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.management.batch.PackageState;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * An application package which represents a particular version of an
 * application.
 */
@JsonFlatten
public class ApplicationPackageInner extends ProxyResource {
    /**
     * The current state of the application package. Possible values include:
     * 'Pending', 'Active'.
     */
    @JsonProperty(value = "properties.state", access = JsonProperty.Access.WRITE_ONLY)
    private PackageState state;

    /**
     * The format of the application package, if the package is active.
     */
    @JsonProperty(value = "properties.format", access = JsonProperty.Access.WRITE_ONLY)
    private String format;

    /**
     * The URL for the application package in Azure Storage.
     */
    @JsonProperty(value = "properties.storageUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String storageUrl;

    /**
     * The UTC time at which the Azure Storage URL will expire.
     */
    @JsonProperty(value = "properties.storageUrlExpiry", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime storageUrlExpiry;

    /**
     * The time at which the package was last activated, if the package is
     * active.
     */
    @JsonProperty(value = "properties.lastActivationTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastActivationTime;

    /**
     * The ETag of the resource, used for concurrency statements.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Get the current state of the application package. Possible values include: 'Pending', 'Active'.
     *
     * @return the state value
     */
    public PackageState state() {
        return this.state;
    }

    /**
     * Get the format of the application package, if the package is active.
     *
     * @return the format value
     */
    public String format() {
        return this.format;
    }

    /**
     * Get the URL for the application package in Azure Storage.
     *
     * @return the storageUrl value
     */
    public String storageUrl() {
        return this.storageUrl;
    }

    /**
     * Get the UTC time at which the Azure Storage URL will expire.
     *
     * @return the storageUrlExpiry value
     */
    public DateTime storageUrlExpiry() {
        return this.storageUrlExpiry;
    }

    /**
     * Get the time at which the package was last activated, if the package is active.
     *
     * @return the lastActivationTime value
     */
    public DateTime lastActivationTime() {
        return this.lastActivationTime;
    }

    /**
     * Get the ETag of the resource, used for concurrency statements.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

}
