/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.batch.CertificateCancelDeletionHeaders;
import com.microsoft.azure.management.batch.CertificateCreateHeaders;
import com.microsoft.azure.management.batch.CertificateCreateOrUpdateParameters;
import com.microsoft.azure.management.batch.CertificateDeleteHeaders;
import com.microsoft.azure.management.batch.CertificateGetHeaders;
import com.microsoft.azure.management.batch.CertificateUpdateHeaders;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.PATCH;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Certificates.
 */
public class CertificatesInner {
    /** The Retrofit service to perform REST calls. */
    private CertificatesService service;
    /** The service client containing this operation class. */
    private BatchManagementClientImpl client;

    /**
     * Initializes an instance of CertificatesInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public CertificatesInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = retrofit.create(CertificatesService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Certificates to be
     * used by Retrofit to perform actually REST calls.
     */
    interface CertificatesService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates listByBatchAccount" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates")
        Observable<Response<ResponseBody>> listByBatchAccount(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("subscriptionId") String subscriptionId, @Query("maxresults") Integer maxresults, @Query("$select") String select, @Query("$filter") String filter, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("certificateName") String certificateName, @Path("subscriptionId") String subscriptionId, @Body CertificateCreateOrUpdateParameters parameters, @Header("If-Match") String ifMatch, @Header("If-None-Match") String ifNoneMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates update" })
        @PATCH("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}")
        Observable<Response<ResponseBody>> update(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("certificateName") String certificateName, @Path("subscriptionId") String subscriptionId, @Body CertificateCreateOrUpdateParameters parameters, @Header("If-Match") String ifMatch, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("certificateName") String certificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("certificateName") String certificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("certificateName") String certificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates cancelDeletion" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/certificates/{certificateName}/cancelDelete")
        Observable<Response<ResponseBody>> cancelDeletion(@Path("resourceGroupName") String resourceGroupName, @Path("accountName") String accountName, @Path("certificateName") String certificateName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Certificates listByBatchAccountNext" })
        @GET
        Observable<Response<ResponseBody>> listByBatchAccountNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateInner&gt; object if successful.
     */
    public PagedList<CertificateInner> listByBatchAccount(final String resourceGroupName, final String accountName) {
        ServiceResponse<Page<CertificateInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<CertificateInner>(response.body()) {
            @Override
            public Page<CertificateInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CertificateInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final ListOperationCallback<CertificateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName),
            new Func1<String, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateInner&gt; object
     */
    public Observable<Page<CertificateInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName)
            .map(new Func1<ServiceResponse<Page<CertificateInner>>, Page<CertificateInner>>() {
                @Override
                public Page<CertificateInner> call(ServiceResponse<Page<CertificateInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateInner&gt; object
     */
    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName)
            .concatMap(new Func1<ServiceResponse<Page<CertificateInner>>, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(ServiceResponse<Page<CertificateInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CertificateInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final Integer maxresults = null;
        final String select = null;
        final String filter = null;
        return service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CertificateInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CertificateInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are "properties/provisioningState", "properties/provisioningStateTransitionTime", "name".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateInner&gt; object if successful.
     */
    public PagedList<CertificateInner> listByBatchAccount(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        ServiceResponse<Page<CertificateInner>> response = listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter).toBlocking().single();
        return new PagedList<CertificateInner>(response.body()) {
            @Override
            public Page<CertificateInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are "properties/provisioningState", "properties/provisioningStateTransitionTime", "name".
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CertificateInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter, final ListOperationCallback<CertificateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter),
            new Func1<String, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are "properties/provisioningState", "properties/provisioningStateTransitionTime", "name".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateInner&gt; object
     */
    public Observable<Page<CertificateInner>> listByBatchAccountAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        return listByBatchAccountWithServiceResponseAsync(resourceGroupName, accountName, maxresults, select, filter)
            .map(new Func1<ServiceResponse<Page<CertificateInner>>, Page<CertificateInner>>() {
                @Override
                public Page<CertificateInner> call(ServiceResponse<Page<CertificateInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param maxresults The maximum number of items to return in the response.
     * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
     * @param filter OData filter expression. Valid properties for filtering are "properties/provisioningState", "properties/provisioningStateTransitionTime", "name".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateInner&gt; object
     */
    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountWithServiceResponseAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        return listByBatchAccountSinglePageAsync(resourceGroupName, accountName, maxresults, select, filter)
            .concatMap(new Func1<ServiceResponse<Page<CertificateInner>>, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(ServiceResponse<Page<CertificateInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
    ServiceResponse<PageImpl<CertificateInner>> * @param resourceGroupName The name of the resource group that contains the Batch account.
    ServiceResponse<PageImpl<CertificateInner>> * @param accountName The name of the Batch account.
    ServiceResponse<PageImpl<CertificateInner>> * @param maxresults The maximum number of items to return in the response.
    ServiceResponse<PageImpl<CertificateInner>> * @param select Comma separated list of properties that should be returned. e.g. "properties/provisioningState". Only top level properties under properties/ are valid for selection.
    ServiceResponse<PageImpl<CertificateInner>> * @param filter OData filter expression. Valid properties for filtering are "properties/provisioningState", "properties/provisioningStateTransitionTime", "name".
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CertificateInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountSinglePageAsync(final String resourceGroupName, final String accountName, final Integer maxresults, final String select, final String filter) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listByBatchAccount(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, select, filter, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CertificateInner>> result = listByBatchAccountDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CertificateInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CertificateInner>> listByBatchAccountDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CertificateInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CertificateInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateInner object if successful.
     */
    public CertificateInner create(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, final ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters), serviceCallback);
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).map(new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>, CertificateInner>() {
            @Override
            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        final String ifNoneMatch = null;
        return service.create(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @param ifMatch The entity state (ETag) version of the certificate to update. A value of "*" can be used to apply the operation only if the certificate already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new certificate to be created, but to prevent updating an existing certificate. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateInner object if successful.
     */
    public CertificateInner create(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch, ifNoneMatch).toBlocking().single().body();
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @param ifMatch The entity state (ETag) version of the certificate to update. A value of "*" can be used to apply the operation only if the certificate already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new certificate to be created, but to prevent updating an existing certificate. Other values will be ignored.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch, final ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch, ifNoneMatch), serviceCallback);
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @param ifMatch The entity state (ETag) version of the certificate to update. A value of "*" can be used to apply the operation only if the certificate already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new certificate to be created, but to prevent updating an existing certificate. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<CertificateInner> createAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch) {
        return createWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch, ifNoneMatch).map(new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>, CertificateInner>() {
            @Override
            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a new certificate inside the specified account.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Additional parameters for certificate creation.
     * @param ifMatch The entity state (ETag) version of the certificate to update. A value of "*" can be used to apply the operation only if the certificate already exists. If omitted, this operation will always be applied.
     * @param ifNoneMatch Set to '*' to allow a new certificate to be created, but to prevent updating an existing certificate. Other values will be ignored.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, String ifNoneMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.create(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, ifNoneMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> clientResponse = createDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateCreateHeaders> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CertificateInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CertificateInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, CertificateCreateHeaders.class);
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateInner object if successful.
     */
    public CertificateInner update(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).toBlocking().single().body();
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, final ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters), serviceCallback);
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters).map(new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>, CertificateInner>() {
            @Override
            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        final String ifMatch = null;
        return service.update(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @param ifMatch The entity state (ETag) version of the certificate to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateInner object if successful.
     */
    public CertificateInner update(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch).toBlocking().single().body();
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @param ifMatch The entity state (ETag) version of the certificate to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch, final ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch), serviceCallback);
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @param ifMatch The entity state (ETag) version of the certificate to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<CertificateInner> updateAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch) {
        return updateWithServiceResponseAsync(resourceGroupName, accountName, certificateName, parameters, ifMatch).map(new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>, CertificateInner>() {
            @Override
            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Updates the properties of an existing certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param parameters Certificate entity to update.
     * @param ifMatch The entity state (ETag) version of the certificate to update. This value can be omitted or set to "*" to apply the operation unconditionally.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName, CertificateCreateOrUpdateParameters parameters, String ifMatch) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.update(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), parameters, ifMatch, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> clientResponse = updateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateUpdateHeaders> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CertificateInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CertificateInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, CertificateUpdateHeaders.class);
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String accountName, String certificateName) {
        deleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().last().body();
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String certificateName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(deleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String certificateName) {
        return deleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map(new Func1<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>, Void>() {
            @Override
            public Void call(ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultWithHeadersAsync(observable, new TypeToken<Void>() { }.getType(), CertificateDeleteHeaders.class);
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String accountName, String certificateName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().single().body();
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String accountName, String certificateName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponseWithHeaders} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String accountName, String certificateName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map(new Func1<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>, Void>() {
            @Override
            public Void call(ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponseWithHeaders} object if successful.
     */
    public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<Void, CertificateDeleteHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<Void, CertificateDeleteHeaders> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, CertificateDeleteHeaders.class);
    }

    /**
     * Gets information about the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateInner object if successful.
     */
    public CertificateInner get(String resourceGroupName, String accountName, String certificateName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().single().body();
    }

    /**
     * Gets information about the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CertificateInner> getAsync(String resourceGroupName, String accountName, String certificateName, final ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(getWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    /**
     * Gets information about the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<CertificateInner> getAsync(String resourceGroupName, String accountName, String certificateName) {
        return getWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map(new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>, CertificateInner>() {
            @Override
            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about the specified certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateGetHeaders> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CertificateInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CertificateInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, CertificateGetHeaders.class);
    }

    /**
     * Cancels a failed deletion of a certificate from the specified account.
     * If you try to delete a certificate that is being used by a pool or compute node, the status of the certificate changes to deleteFailed. If you decide that you want to continue using the certificate, you can use this operation to set the status of the certificate back to active. If you intend to delete the certificate, you do not need to run this operation after the deletion failed. You must make sure that the certificate is not being used by any resources, and then you can try again to delete the certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the CertificateInner object if successful.
     */
    public CertificateInner cancelDeletion(String resourceGroupName, String accountName, String certificateName) {
        return cancelDeletionWithServiceResponseAsync(resourceGroupName, accountName, certificateName).toBlocking().single().body();
    }

    /**
     * Cancels a failed deletion of a certificate from the specified account.
     * If you try to delete a certificate that is being used by a pool or compute node, the status of the certificate changes to deleteFailed. If you decide that you want to continue using the certificate, you can use this operation to set the status of the certificate back to active. If you intend to delete the certificate, you do not need to run this operation after the deletion failed. You must make sure that the certificate is not being used by any resources, and then you can try again to delete the certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<CertificateInner> cancelDeletionAsync(String resourceGroupName, String accountName, String certificateName, final ServiceCallback<CertificateInner> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(cancelDeletionWithServiceResponseAsync(resourceGroupName, accountName, certificateName), serviceCallback);
    }

    /**
     * Cancels a failed deletion of a certificate from the specified account.
     * If you try to delete a certificate that is being used by a pool or compute node, the status of the certificate changes to deleteFailed. If you decide that you want to continue using the certificate, you can use this operation to set the status of the certificate back to active. If you intend to delete the certificate, you do not need to run this operation after the deletion failed. You must make sure that the certificate is not being used by any resources, and then you can try again to delete the certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<CertificateInner> cancelDeletionAsync(String resourceGroupName, String accountName, String certificateName) {
        return cancelDeletionWithServiceResponseAsync(resourceGroupName, accountName, certificateName).map(new Func1<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>, CertificateInner>() {
            @Override
            public CertificateInner call(ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders> response) {
                return response.body();
            }
        });
    }

    /**
     * Cancels a failed deletion of a certificate from the specified account.
     * If you try to delete a certificate that is being used by a pool or compute node, the status of the certificate changes to deleteFailed. If you decide that you want to continue using the certificate, you can use this operation to set the status of the certificate back to active. If you intend to delete the certificate, you do not need to run this operation after the deletion failed. You must make sure that the certificate is not being used by any resources, and then you can try again to delete the certificate.
     *
     * @param resourceGroupName The name of the resource group that contains the Batch account.
     * @param accountName The name of the Batch account.
     * @param certificateName The identifier for the certificate. This must be made up of algorithm and thumbprint separated by a dash, and must match the certificate data in the request. For example SHA1-a3d1c5.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the CertificateInner object
     */
    public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>> cancelDeletionWithServiceResponseAsync(String resourceGroupName, String accountName, String certificateName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.cancelDeletion(resourceGroupName, accountName, certificateName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>>>() {
                @Override
                public Observable<ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders> clientResponse = cancelDeletionDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponseWithHeaders<CertificateInner, CertificateCancelDeletionHeaders> cancelDeletionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<CertificateInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<CertificateInner>() { }.getType())
                .registerError(CloudException.class)
                .buildWithHeaders(response, CertificateCancelDeletionHeaders.class);
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;CertificateInner&gt; object if successful.
     */
    public PagedList<CertificateInner> listByBatchAccountNext(final String nextPageLink) {
        ServiceResponse<Page<CertificateInner>> response = listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateInner>(response.body()) {
            @Override
            public Page<CertificateInner> nextPage(String nextPageLink) {
                return listByBatchAccountNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<CertificateInner>> listByBatchAccountNextAsync(final String nextPageLink, final ServiceFuture<List<CertificateInner>> serviceFuture, final ListOperationCallback<CertificateInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByBatchAccountNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(String nextPageLink) {
                    return listByBatchAccountNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateInner&gt; object
     */
    public Observable<Page<CertificateInner>> listByBatchAccountNextAsync(final String nextPageLink) {
        return listByBatchAccountNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<CertificateInner>>, Page<CertificateInner>>() {
                @Override
                public Page<CertificateInner> call(ServiceResponse<Page<CertificateInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;CertificateInner&gt; object
     */
    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountNextWithServiceResponseAsync(final String nextPageLink) {
        return listByBatchAccountNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<CertificateInner>>, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(ServiceResponse<Page<CertificateInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByBatchAccountNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Lists all of the certificates in the specified account.
     *
    ServiceResponse<PageImpl<CertificateInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;CertificateInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<CertificateInner>>> listByBatchAccountNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByBatchAccountNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<CertificateInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<CertificateInner>> result = listByBatchAccountNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<CertificateInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<CertificateInner>> listByBatchAccountNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<CertificateInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<CertificateInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
