/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import java.util.List;
import com.microsoft.azure.management.batch.EndpointDependency;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A collection of related endpoints from the same service for which the Batch
 * service requires outbound access.
 */
public class OutboundEnvironmentEndpointInner {
    /**
     * The type of service that the Batch service connects to.
     */
    @JsonProperty(value = "category", access = JsonProperty.Access.WRITE_ONLY)
    private String category;

    /**
     * The endpoints for this service to which the Batch service makes outbound
     * calls.
     */
    @JsonProperty(value = "endpoints", access = JsonProperty.Access.WRITE_ONLY)
    private List<EndpointDependency> endpoints;

    /**
     * Get the type of service that the Batch service connects to.
     *
     * @return the category value
     */
    public String category() {
        return this.category;
    }

    /**
     * Get the endpoints for this service to which the Batch service makes outbound calls.
     *
     * @return the endpoints value
     */
    public List<EndpointDependency> endpoints() {
        return this.endpoints;
    }

}
