/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A collection of environment variables with secret values to set.
 */
public class EnvironmentVariableWithSecretValue {
    /**
     * The name of the environment variable to store the secret value.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The value of the environment variable. This value will never be reported
     * back by Batch AI.
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Specifies the location of the Azure KeyVault secret which will be used
     * as the environment variable value.
     * Specifies KeyVault Store and Secret which contains the value for the
     * environment variable. One of value or valueSecretReference must be
     * provided.
     */
    @JsonProperty(value = "valueSecretReference")
    private KeyVaultSecretReference valueSecretReference;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the EnvironmentVariableWithSecretValue object itself.
     */
    public EnvironmentVariableWithSecretValue withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value value.
     *
     * @return the value value
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value value.
     *
     * @param value the value value to set
     * @return the EnvironmentVariableWithSecretValue object itself.
     */
    public EnvironmentVariableWithSecretValue withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the valueSecretReference value.
     *
     * @return the valueSecretReference value
     */
    public KeyVaultSecretReference valueSecretReference() {
        return this.valueSecretReference;
    }

    /**
     * Set the valueSecretReference value.
     *
     * @param valueSecretReference the valueSecretReference value to set
     * @return the EnvironmentVariableWithSecretValue object itself.
     */
    public EnvironmentVariableWithSecretValue withValueSecretReference(KeyVaultSecretReference valueSecretReference) {
        this.valueSecretReference = valueSecretReference;
        return this;
    }

}
