/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.batchai.CachingType;
import com.microsoft.azure.management.batchai.DataDisks;
import com.microsoft.azure.management.batchai.FileServerProvisioningState;
import com.microsoft.azure.management.batchai.MountSettings;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.SshConfiguration;
import com.microsoft.azure.management.batchai.StorageAccountType;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.FileServerInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import org.joda.time.DateTime;

@Fluent
@Beta(value=Beta.SinceVersion.V1_6_0)
public interface BatchAIFileServer
extends GroupableResource<BatchAIManager, FileServerInner>,
Refreshable<BatchAIFileServer> {
    public String vmSize();

    public SshConfiguration sshConfiguration();

    public DataDisks dataDisks();

    public ResourceId subnet();

    public MountSettings mountSettings();

    public DateTime provisioningStateTransitionTime();

    public DateTime creationTime();

    public FileServerProvisioningState provisioningState();

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<BatchAIFileServer>,
        Resource.DefinitionWithTags<WithCreate>,
        WithUserCredentials,
        WithSubnet {
        }

        @Beta(value=Beta.SinceVersion.V1_8_0)
        public static interface WithSubnet {
            public WithCreate withSubnet(String var1);

            public WithCreate withSubnet(String var1, String var2);
        }

        public static interface WithUserCredentials {
            public WithCreate withPassword(String var1);

            public WithCreate withSshPublicKey(String var1);
        }

        public static interface WithUserName {
            public WithUserCredentials withUserName(String var1);
        }

        public static interface WithVMSize {
            public WithUserName withVMSize(String var1);
        }

        public static interface WithDataDisks {
            public WithVMSize withDataDisks(int var1, int var2, StorageAccountType var3);

            public WithVMSize withDataDisks(int var1, int var2, StorageAccountType var3, CachingType var4);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithDataDisks> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithDataDisks,
    DefinitionStages.WithVMSize,
    DefinitionStages.WithUserName,
    DefinitionStages.WithUserCredentials,
    DefinitionStages.WithCreate {
    }
}

