/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIFileServer;
import com.microsoft.azure.management.batchai.CachingType;
import com.microsoft.azure.management.batchai.DataDisks;
import com.microsoft.azure.management.batchai.FileServerProvisioningState;
import com.microsoft.azure.management.batchai.MountSettings;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.SshConfiguration;
import com.microsoft.azure.management.batchai.StorageAccountType;
import com.microsoft.azure.management.batchai.UserAccountSettings;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.FileServerCreateParametersInner;
import com.microsoft.azure.management.batchai.implementation.FileServerInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class BatchAIFileServerImpl
extends GroupableResourceImpl<BatchAIFileServer, FileServerInner, BatchAIFileServerImpl, BatchAIManager>
implements BatchAIFileServer,
BatchAIFileServer.Definition {
    private FileServerCreateParametersInner createParameters = new FileServerCreateParametersInner();

    BatchAIFileServerImpl(String name, FileServerInner innerObject, BatchAIManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    public Observable<BatchAIFileServer> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((FileServerInner)((Object)this.inner())).getTags());
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).fileServers().createAsync(this.resourceGroupName(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<FileServerInner> getInnerAsync() {
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).fileServers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public BatchAIFileServerImpl withVMSize(String vmSize) {
        this.createParameters.withVmSize(vmSize);
        return this;
    }

    @Override
    public BatchAIFileServerImpl withUserName(String userName) {
        this.ensureUserAccountSettings().withAdminUserName(userName);
        return this;
    }

    @Override
    public BatchAIFileServer.DefinitionStages.WithCreate withSubnet(String subnetId) {
        this.createParameters.withSubnet(new ResourceId().withId(subnetId));
        return this;
    }

    @Override
    public BatchAIFileServer.DefinitionStages.WithCreate withSubnet(String networkId, String subnetName) {
        this.createParameters.withSubnet(new ResourceId().withId(networkId + "/subnets/" + subnetName));
        return this;
    }

    private UserAccountSettings ensureUserAccountSettings() {
        if (this.ensureSshConfiguration().userAccountSettings() == null) {
            this.createParameters.sshConfiguration().withUserAccountSettings(new UserAccountSettings());
        }
        return this.createParameters.sshConfiguration().userAccountSettings();
    }

    private SshConfiguration ensureSshConfiguration() {
        if (this.createParameters.sshConfiguration() == null) {
            this.createParameters.withSshConfiguration(new SshConfiguration());
        }
        return this.createParameters.sshConfiguration();
    }

    @Override
    public BatchAIFileServerImpl withPassword(String password) {
        this.ensureUserAccountSettings().withAdminUserPassword(password);
        return this;
    }

    @Override
    public BatchAIFileServerImpl withSshPublicKey(String sshPublicKey) {
        this.ensureUserAccountSettings().withAdminUserSshPublicKey(sshPublicKey);
        return this;
    }

    @Override
    public BatchAIFileServer.DefinitionStages.WithVMSize withDataDisks(int diskSizeInGB, int diskCount, StorageAccountType storageAccountType) {
        this.ensureDataDisks().withDiskSizeInGB(diskSizeInGB).withDiskCount(diskCount).withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public BatchAIFileServer.DefinitionStages.WithVMSize withDataDisks(int diskSizeInGB, int diskCount, StorageAccountType storageAccountType, CachingType cachingType) {
        this.ensureDataDisks().withDiskSizeInGB(diskSizeInGB).withDiskCount(diskCount).withStorageAccountType(storageAccountType).withCachingType(cachingType);
        return this;
    }

    private DataDisks ensureDataDisks() {
        if (this.createParameters.dataDisks() == null) {
            this.createParameters.withDataDisks(new DataDisks());
        }
        return this.createParameters.dataDisks();
    }

    @Override
    public String vmSize() {
        return ((FileServerInner)((Object)this.inner())).vmSize();
    }

    @Override
    public SshConfiguration sshConfiguration() {
        return ((FileServerInner)((Object)this.inner())).sshConfiguration();
    }

    @Override
    public DataDisks dataDisks() {
        return ((FileServerInner)((Object)this.inner())).dataDisks();
    }

    @Override
    public ResourceId subnet() {
        return ((FileServerInner)((Object)this.inner())).subnet();
    }

    @Override
    public MountSettings mountSettings() {
        return ((FileServerInner)((Object)this.inner())).mountSettings();
    }

    @Override
    public DateTime provisioningStateTransitionTime() {
        return ((FileServerInner)((Object)this.inner())).provisioningStateTransitionTime();
    }

    @Override
    public DateTime creationTime() {
        return ((FileServerInner)((Object)this.inner())).creationTime();
    }

    @Override
    public FileServerProvisioningState provisioningState() {
        return ((FileServerInner)((Object)this.inner())).provisioningState();
    }
}

