/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.BatchAIJob;
import com.microsoft.azure.management.batchai.BatchAIJobs;
import com.microsoft.azure.management.batchai.implementation.BatchAIClusterImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.batchai.implementation.JobsInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BatchAIJobsImpl
extends GroupableResourcesImpl<BatchAIJob, BatchAIJobImpl, JobInner, JobsInner, BatchAIManager>
implements BatchAIJobs {
    private final BatchAIClusterImpl parent;

    BatchAIJobsImpl(BatchAIClusterImpl parent) {
        super((Object)((BatchAIManagementClientImpl)((Object)((BatchAIManager)parent.manager()).inner())).jobs(), parent.manager());
        this.parent = parent;
    }

    BatchAIJobsImpl(BatchAIManager manager) {
        super((Object)((BatchAIManagementClientImpl)((Object)manager.inner())).jobs(), (ManagerBase)manager);
        this.parent = null;
    }

    protected BatchAIJobImpl wrapModel(String name) {
        return new BatchAIJobImpl(name, new JobInner(), (BatchAIManager)this.manager());
    }

    protected BatchAIJobImpl wrapModel(JobInner inner) {
        if (inner == null) {
            return null;
        }
        return new BatchAIJobImpl(inner.name(), inner, (BatchAIManager)this.manager());
    }

    public BatchAIJobImpl define(String name) {
        return this.wrapModel(name);
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((JobsInner)this.inner()).deleteAsync(this.parent.resourceGroupName(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return ((JobsInner)this.inner()).deleteAsync(this.parent.resourceGroupName(), name).toCompletable();
    }

    public PagedList<BatchAIJob> list() {
        return new GroupPagedList<BatchAIJob>(((BatchAIManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<BatchAIJob> listNextGroup(String resourceGroupName) {
                return BatchAIJobsImpl.this.wrapList(((JobsInner)BatchAIJobsImpl.this.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public BatchAIJob getByName(String name) {
        JobInner inner = ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).jobs().getByResourceGroup(this.parent().resourceGroupName(), name);
        return new BatchAIJobImpl(name, inner, (BatchAIManager)this.manager());
    }

    public BatchAICluster parent() {
        return this.parent;
    }

    public Observable<BatchAIJob> listAsync() {
        return ((BatchAIManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<BatchAIJob>>(){

            public Observable<BatchAIJob> call(ResourceGroup resourceGroup) {
                return BatchAIJobsImpl.this.wrapPageAsync(((JobsInner)BatchAIJobsImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    protected Observable<JobInner> getInnerAsync(String resourceGroupName, String name) {
        return ((JobsInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        return ((JobsInner)this.inner()).deleteAsync(resourceGroupName, name).toCompletable();
    }

    public Observable<BatchAIJob> getByNameAsync(String name) {
        return ((JobsInner)this.inner()).getByResourceGroupAsync(this.parent.resourceGroupName(), name).map((Func1)new Func1<JobInner, BatchAIJob>(){

            public BatchAIJob call(JobInner inner) {
                return BatchAIJobsImpl.this.wrapModel(inner);
            }
        });
    }
}

