/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ExecutionState.
 */
public enum ExecutionState {
    /** Enum value queued. */
    QUEUED("queued"),

    /** Enum value running. */
    RUNNING("running"),

    /** Enum value terminating. */
    TERMINATING("terminating"),

    /** Enum value succeeded. */
    SUCCEEDED("succeeded"),

    /** Enum value failed. */
    FAILED("failed");

    /** The actual serialized value for a ExecutionState instance. */
    private String value;

    ExecutionState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ExecutionState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ExecutionState object, or null if unable to parse.
     */
    @JsonCreator
    public static ExecutionState fromString(String value) {
        ExecutionState[] items = ExecutionState.values();
        for (ExecutionState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
