/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies a setup task which can be used to customize the compute nodes of
 * the cluster.
 */
public class SetupTask {
    /**
     * Command Line to start Setup process.
     */
    @JsonProperty(value = "commandLine", required = true)
    private String commandLine;

    /**
     * Collection of environment variables to be set for setup task.
     */
    @JsonProperty(value = "environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /**
     * Collection of environment variables with secret values to be set for
     * setup task.
     * Server will never report values of these variables back.
     */
    @JsonProperty(value = "secrets")
    private List<EnvironmentVariableWithSecretValue> secrets;

    /**
     * Specifies whether to run the setup task under root account. The default
     * value is false.
     * Note. Non-elevated tasks are run under an account added into sudoer list
     * and can perform sudo when required.
     */
    @JsonProperty(value = "runElevated")
    private Boolean runElevated;

    /**
     * The prefix of a path where the Batch AI service will upload the stdout
     * and stderr of the setup task.
     */
    @JsonProperty(value = "stdOutErrPathPrefix", required = true)
    private String stdOutErrPathPrefix;

    /**
     * A path segment appended by Batch AI to stdOutErrPathPrefix to form a
     * path where stdout and stderr of the setup task will be uploaded.
     * Batch AI creates the setup task output directories under an unique path
     * to avoid conflicts between different clusters. You can concatinate
     * stdOutErrPathPrefix and stdOutErrPathSuffix to get the full path to the
     * output directory.
     */
    @JsonProperty(value = "stdOutErrPathSuffix", access = JsonProperty.Access.WRITE_ONLY)
    private String stdOutErrPathSuffix;

    /**
     * Get the commandLine value.
     *
     * @return the commandLine value
     */
    public String commandLine() {
        return this.commandLine;
    }

    /**
     * Set the commandLine value.
     *
     * @param commandLine the commandLine value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    /**
     * Get the environmentVariables value.
     *
     * @return the environmentVariables value
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables value.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the secrets value.
     *
     * @return the secrets value
     */
    public List<EnvironmentVariableWithSecretValue> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets value.
     *
     * @param secrets the secrets value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withSecrets(List<EnvironmentVariableWithSecretValue> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the runElevated value.
     *
     * @return the runElevated value
     */
    public Boolean runElevated() {
        return this.runElevated;
    }

    /**
     * Set the runElevated value.
     *
     * @param runElevated the runElevated value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withRunElevated(Boolean runElevated) {
        this.runElevated = runElevated;
        return this;
    }

    /**
     * Get the stdOutErrPathPrefix value.
     *
     * @return the stdOutErrPathPrefix value
     */
    public String stdOutErrPathPrefix() {
        return this.stdOutErrPathPrefix;
    }

    /**
     * Set the stdOutErrPathPrefix value.
     *
     * @param stdOutErrPathPrefix the stdOutErrPathPrefix value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withStdOutErrPathPrefix(String stdOutErrPathPrefix) {
        this.stdOutErrPathPrefix = stdOutErrPathPrefix;
        return this;
    }

    /**
     * Get the stdOutErrPathSuffix value.
     *
     * @return the stdOutErrPathSuffix value
     */
    public String stdOutErrPathSuffix() {
        return this.stdOutErrPathSuffix;
    }

}
